// Matt Pierce
// 2 February, 2002
// "star_backdrop.h"
// This header file contains the drawing functions for the
// background on which "Hello Kitty" will be placed.  It
// takes advantage of some very simple geometry to create
// 36-pointed stars which rotate at different speeds.

void singleStar(int timecheck, float r, float g, float b)
{
	int angle;
	float width=0.1;
	float length=1;
	float x[3], y[3];
	float adjustedAngle;
	for (angle=0; angle<360; angle+=10)
	{
		adjustedAngle= angle + (timecheck/100.0);
		x[0] = width*cos((adjustedAngle-90)*PI/180.0);
		y[0] = width*sin((adjustedAngle-90)*PI/180.0);

		x[1] = width*cos((adjustedAngle+90)*PI/180.0);
		y[1] = width*sin((adjustedAngle+90)*PI/180.0);

		x[2] = length*cos(adjustedAngle*PI/180.0);
		y[2] = length*sin(adjustedAngle*PI/180.0);

		glBegin(GL_POLYGON);
			glColor3f(r,g,b);
			glVertex3f(x[0],y[0],0);
			glVertex3f(x[1],y[1],0);
			glVertex3f(x[2],y[2],0);
		glEnd();
	}
}

void starBackdrop(void)
{
	int time_check=glutGet(GLUT_ELAPSED_TIME);
	singleStar(time_check, 0.6, 0.6, 1.0);
	singleStar(time_check*2, 0.7, 0.7, 1.0);
}