// Matt Pierce
// 2 February, 2002
// "lab_1.cpp"
// My first attempt to use GLUT for Computer Graphics Class.
// A demonstration of an animal drawn with polygons.
// In this case, it's the ever-cute Hello Kitty.

// Outside Library Includes
#include <GL\glut.h>                // The header for GLUT
#include <math.h>                   // for sin & cos functions
#include <windows.h>

// Project File Includes
const float PI = 3.1415926;         // PI -- Just in case
#include "kitty.h"                  // holds the drawing functions for our character
#include "star_backdrop.h"			// holds the drawing functions for the background

const int WINDOW_WIDE = 300;		// The initial width of the window
const int WINDOW_HIGH = 300;		// The initial height of the window

float aspect_corrector;				// This will allow me to correct the aspect of a
int aspect_flag=0;					// resized window manually.  I hate to use a
									// global variable, but I fear this is the
									// only way.

// void display(void)
// Purpose: Handles all drawing functions.
// Called by: GLUT subsystem anytime the screen needs updating.
// Parameters: none
// 
void display(void)
{
	// By basing our animation off the clock, we get a constant
	// rate of motion regardless of the framerate.
	// As you will see later, I base the motion off of the clock
	// and a sine or cosine wave.  This is an effective method
	// as it creates a gentle, smooth oscilation.
	int time_check=glutGet(GLUT_ELAPSED_TIME);

	// Clear the screen to prepare for drawing
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glPushMatrix();
		// Using glScalef to either reduce or expand our image horizontally
		// to adjust for the aspect ratio of our window.
		if (aspect_flag==0)
			glScalef(aspect_corrector, 1, 1);
		else
			glScalef(1, aspect_corrector, 1);
		// Call outside function to draw the background (from "star_backdrop.h")
		starBackdrop();

		// Because we are using an ortographic view, I disabled Depth-testing.
		// Because I disabled depth-testing, things are drawn in the order they
		// are sent to the GL subsystem.  This simplifies the process for 2d graphics,
		// as you can re-arrange things easily to be in front or in back of
		// other things.  The first thing drawn is the farthest back.
	
		// Call outside function to draw the shadow under the character (from "kitty.h")
		kittyDrawShadow();
		// Call outside functions to draw the arms (from "kitty.h")
		kittyDrawRightArm(5*sin(time_check/400.0));
		kittyDrawLeftArm(10*cos(time_check/400.0)+110);
		// Call outside function to  draw the torso (from "kitty.h")
		kittyDrawBody();
		// Call outside function to draw the feet (from "kitty.h")
		kittyDrawRightFoot(0);
		kittyDrawLeftFoot(0);
		// Call outside function to draw the head (from "kitty.h")
		kittyDrawHead(10*sin(time_check/500.0));
	glPopMatrix();

	// Post to the screen
	glutSwapBuffers();
	// Clear out the Geometry Matrix (omission creates drawing errors)
	glFlush();
	// A short sleep to avoid monopolizing the processor.
	Sleep(5);
}

// void resize(int width, int height)
// Purpose: Updates our program to conform with a new screen position and size.
// Called by: GLUT subsystem whenever the window is reshaped in any way
// Called by: void init(void) to set up a viewport for the first time
// Parameters:
//   width: the width in pixels of the new window
//   height: the height in pixels of the new window
void resize(int width, int height)
{
	// Get our new aspect ratio.
	if (width<height)
	{
		aspect_flag = 0;
		if (width!=0) aspect_corrector = (float)height/(float)width;
	} else {
		aspect_flag = 1;
		if (height!=0) aspect_corrector = (float)width/(float)height;
	}

	// Resize the glVeiwport (active area of screen)
	glLoadIdentity();
	glViewport(0,0,width, height);
}

// void init(void)
// Purpose: Initializes GL core and rendering settings
// Called by: int main(int argc, char ** argv)
// Parameters: none
void init(void)
{
	// Enable alpha blending and set to a normal alpha blend mode
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	// Disable depth testing (uneccecary because we are working in 2D mode)
	glDisable(GL_DEPTH_TEST);
	// Set background clear color to a light blue
	glClearColor(0.5,0.5,0.9, 1.0);
	// call resize to set up our first viewport
	resize(WINDOW_WIDE, WINDOW_HIGH);
}

// int main(int argc, char** argv)
// Purpose: Main section of our program
// Called by: N/A
// Parameters:
//   argc: number of strings from the command line
//   argv: pointer to array of strings
int main(int argc, char ** argv)
{
	// because we aren't doing anything with the command line
	// parameters, we pass them to the GLUT system just in case
	// GLUT needs them.
	glutInit(&argc, argv);
	// Initialize GLUT display & window
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH);
	glutInitWindowSize(WINDOW_WIDE, WINDOW_HIGH);
	glutCreateWindow("Lab 1: Hello Kitty in GLUT");
	// Call our Initialize function
	init();
	// Set our default callback functions
	glutDisplayFunc(display);
	glutReshapeFunc(resize);
	glutIdleFunc(display);
	// Hand it off to GLUT
	glutMainLoop();
	// Exit with a non-error return code
	return 0;
}
