// Matt Pierce
// 2 February, 2002
// "kitty.h"
// This file is supposed to be used with "lab_1.cpp".
// The drawing code (as written here) is not quite portable... 
// or at least not as portable as I would like.
// For example, in its current implimentation, it would be fairly
// difficult for me to put, say, two "Hello Kitty"'s on the screen
// with any accuracy in placement.

// Function names are fairly self-explanatory,
// all functions are called by: void display(void) (from lab_1.cpp)

void kittyDrawBow(void)
{
	glPushMatrix();
///////////Left big bow//////
		glBegin(GL_POLYGON);
			glColor3f(1, 1, 0.0);
			glVertex3f(-0.5, 0.5,0);
			glVertex3f(-1.0, 1.0,0);
			glVertex3f(-1.75, 1.0,0);
			glVertex3f(-2, 0.75,0);
			glVertex3f(-2, -0.75,0);
			glVertex3f(-1.75, -1.0 ,0);
			glVertex3f(-1.0, -1.0,0);
			glVertex3f(-0.5, -0.5,0);
		glEnd();
		glBegin(GL_LINES);
			glColor3f(0, 0, 0);
			glVertex3f(-0.5, 0.5,0);
			glVertex3f(-1.0, 1.0,0);
			glVertex3f(-1.0, 1.0,0);
			glVertex3f(-1.75, 1.0,0);
			glVertex3f(-1.75, 1.0,0);
			glVertex3f(-2, 0.75,0);
			glVertex3f(-2, 0.75,0);
			glVertex3f(-2, -0.75,0);
			glVertex3f(-2, -0.75,0);
			glVertex3f(-1.75, -1.0 ,0);
			glVertex3f(-1.75, -1.0 ,0);
			glVertex3f(-1.0, -1.0,0);
			glVertex3f(-1.0, -1.0,0);
			glVertex3f(-0.5, -0.5,0);
		glEnd();
///////////Left Small bow///////////////
		glBegin(GL_POLYGON);
			glColor3f(1, 1, 0.0);
			glVertex3f(-0.5, 0.25,1);
			glVertex3f(-1, 0.5,1);
			glVertex3f(-1.25, 0.5, 1.0);
			glVertex3f(-1.5, 0.25, 1.0);
			glVertex3f(-1.5, -0.25, 1.0);
			glVertex3f(-1.25, -0.5, 1.0);
			glVertex3f(-1, -0.5, 1.0);
			glVertex3f(-0.5, -0.25, 1.0);
		glEnd();
		glBegin(GL_LINES);
			glColor3f(0, 0, 0);
			glVertex3f(-0.5, 0.25,1);
			glVertex3f(-1, 0.5,1);
			glVertex3f(-1, 0.5,1);
			glVertex3f(-1.25, 0.5, 1.0);
			glVertex3f(-1.25, 0.5, 1.0);
			glVertex3f(-1.5, 0.25, 1.0);
			glVertex3f(-1.5, 0.25, 1.0);
			glVertex3f(-1.5, -0.25, 1.0);
			glVertex3f(-1.5, -0.25, 1.0);
			glVertex3f(-1.25, -0.5, 1.0);
			glVertex3f(-1.25, -0.5, 1.0);
			glVertex3f(-1, -0.5, 1.0);
			glVertex3f(-1, -0.5, 1.0);
			glVertex3f(-0.5, -0.25, 1.0);
		glEnd();
//////////right large bow //////////////////
		glBegin(GL_POLYGON);
			glColor3f(1, 1, 0.0);
			glVertex3f(0.5, 0.5,0);
			glVertex3f(1.0, 1.0,0);
			glVertex3f(1.75, 1.0,0);
			glVertex3f(2, 0.75,0);
			glVertex3f(2, -0.75,0);
			glVertex3f(1.75, -1.0 ,0);
			glVertex3f(1.0, -1.0,0);
			glVertex3f(0.5, -0.5,0);
		glEnd();
		glBegin(GL_LINES);
			glColor3f(0, 0, 0);
			glVertex3f(0.5, 0.5,0);
			glVertex3f(1.0, 1.0,0);
			glVertex3f(1.0, 1.0,0);
			glVertex3f(1.75, 1.0,0);
			glVertex3f(1.75, 1.0,0);
			glVertex3f(2, 0.75,0);
			glVertex3f(2, 0.75,0);
			glVertex3f(2, -0.75,0);
			glVertex3f(2, -0.75,0);
			glVertex3f(1.75, -1.0 ,0);
			glVertex3f(1.75, -1.0 ,0);
			glVertex3f(1.0, -1.0,0);
			glVertex3f(1.0, -1.0,0);
			glVertex3f(0.5, -0.5,0);
		glEnd();
/////////right small bow////////////////////
		glBegin(GL_POLYGON);
			glColor3f(1, 1, 0.0);
			glVertex3f(0.5, 0.25,0);
			glVertex3f(1, 0.5,0);
			glVertex3f(1.25, 0.5, 0);
			glVertex3f(1.5, 0.25, 0);
			glVertex3f(1.5, -0.25, 0);
			glVertex3f(1.25, -0.5, 0);
			glVertex3f(1, -0.5, 0);
			glVertex3f(0.5, -0.25, 0);
		glEnd();
		glBegin(GL_LINES);
			glColor3f(0, 0, 0);
			glVertex3f(0.5, 0.25,0);
			glVertex3f(1, 0.5,0);
			glVertex3f(1, 0.5,0);
			glVertex3f(1.25, 0.5, 0);
			glVertex3f(1.25, 0.5, 0);
			glVertex3f(1.5, 0.25, 0);
			glVertex3f(1.5, 0.25, 0);
			glVertex3f(1.5, -0.25, 0);
			glVertex3f(1.5, -0.25, 0);
			glVertex3f(1.25, -0.5, 0);
			glVertex3f(1.25, -0.5, 0);
			glVertex3f(1, -0.5, 0);
			glVertex3f(1, -0.5, 0);
			glVertex3f(0.5, -0.25, 0);
		glEnd();
/////////center knot //////////////////////
		glBegin(GL_POLYGON);
			glColor3f(1, 1, 0.0);
			glVertex3f(0, 0.75, 0);
			glVertex3f(-0.5, 0.5, 0);
			glVertex3f(-0.75, 0, 0);
			glVertex3f(-0.5, -0.5, 0);
			glVertex3f(0, -0.75, 0);
			glVertex3f(0.5, -0.5, 0);
			glVertex3f(0.75, 0, 0);
			glVertex3f(0.5, 0.5, 0);
		glEnd();
		glBegin(GL_LINES);
			glColor3f(0, 0, 0);
			glVertex3f(0, 0.75, -1);
			glVertex3f(-0.5, 0.5, -1);
			glVertex3f(-0.5, 0.5, -1);
			glVertex3f(-0.75, 0, -1);
			glVertex3f(-0.75, 0, -1);
			glVertex3f(-0.5, -0.5, -1);
			glVertex3f(-0.5, -0.5, -1);
			glVertex3f(0, -0.75, -1);
			glVertex3f(0, -0.75, -1);
			glVertex3f(0.5, -0.5, -1);
			glVertex3f(0.5, -0.5, -1);
			glVertex3f(0.75, 0, -1);
			glVertex3f(0.75, 0, -1);
			glVertex3f(0.5, 0.5, -1);
			glVertex3f(0.5, 0.5, -1);
			glVertex3f(0, 0.75, -1);
		glEnd();
	glPopMatrix();
}

void kittyDrawFace(void)
{
	glPushMatrix();
////////////Fur ///////////
		glBegin(GL_POLYGON);
			glColor3f(1,1,1);
			glVertex3f(0,1.1,0);
			glVertex3f(1,1,0);
			glVertex3f(2.5, 0.5, 0);
			glVertex3f(3,0,0);
			glVertex3f(3.25,-0.75, 0);
			glVertex3f(3, -1.25, 0);
			glVertex3f(2.25, -1.75, 0);
			glVertex3f(1, -2, 0);
			glVertex3f(0, -2, 0);
		glEnd();
		glBegin(GL_POLYGON);
			glColor3f(1,1,1);
			glVertex3f(1,1,0);
			glVertex3f(2,1.75,0);
			glVertex3f(2.375,1.625, 0);
			glVertex3f(2.5, 1.5, 0);
			glVertex3f(2.5,0.5,0);
		glEnd();		
///////////Outline //////////////
		glBegin(GL_LINES);
			glColor3f(0,0,0);
			glVertex3f(0,1.1,0);
			glVertex3f(1,1,0);
			glVertex3f(1,1,0);
			glVertex3f(2,1.75,0);
			glVertex3f(2,1.75,0);
			glVertex3f(2.375,1.625, 0);
			glVertex3f(2.375,1.625, 0);
			glVertex3f(2.5, 1.5, 0);
			glVertex3f(2.5, 1.5, 0);
			glVertex3f(2.5, 0.5, 0);
			glVertex3f(2.5, 0.5, 0);
			glVertex3f(3,0,0);
			glVertex3f(3,0,0);
			glVertex3f(3.25,-0.75, 0);
			glVertex3f(3.25,-0.75, 0);
			glVertex3f(3, -1.25, 0);
			glVertex3f(3, -1.25, 0);
			glVertex3f(2.25, -1.75, 0);
			glVertex3f(2.25, -1.75, 0);
			glVertex3f(1, -2, 0);
			glVertex3f(1, -2, 0);
			glVertex3f(0, -2, 0);
		glEnd();
////////////Eye /////////////
		glBegin(GL_POLYGON);
			glColor3f(0,0,0);
			glVertex3f(1.5, -0.75,0);
			glVertex3f(1.625, -0.875, 0);
			glVertex3f(1.5,-1,0);
			glVertex3f(1.375, -0.875, 0);
		glEnd();
////////////Nose/////////////
		glBegin(GL_POLYGON);
			glColor3f(1,0.75,0.75);
			glVertex3f(0,-1.125, 0);
			glVertex3f(0.25, -1.25, 0);
			glVertex3f(0,-1.375,0);
		glEnd();
		glBegin(GL_LINES);
			glColor3f(0,0,0);
			glVertex3f(0,-1.125, 0);
			glVertex3f(0.25, -1.25, 0);
			glVertex3f(0.25, -1.25, 0);
			glVertex3f(0,-1.375,0);
		glEnd();
///////////Whiskers////////////
		glBegin(GL_LINES);
			glColor3f(0,0,0);
			glVertex3f(2.5,-0.75,0);
			glVertex3f(3.5,-0.5, 0);
			glVertex3f(2.5,-1,0);
			glVertex3f(3.75,-1,0);
			glVertex3f(2.5,-1.25,0);
			glVertex3f(3.5,-1.5,0);
		glEnd();
	glPopMatrix();
}

void kittyDrawHead(float rotation)
{
	float facescale=0.185;
	glPushMatrix();
		glRotatef(rotation, 0,0,1);
		glTranslatef(0,0.25,0);
		glPushMatrix();
			glScalef(facescale*0.75, facescale, facescale);
			kittyDrawFace();
		glPopMatrix();
		glPushMatrix();
			glScalef(-facescale*0.75, facescale, facescale);
			kittyDrawFace();
		glPopMatrix();
		glPushMatrix();
			glScalef(0.1, 0.1, 0.1);
			glRotatef(30,0,0,1);
			glTranslatef(-1.9, 3, 0);
			kittyDrawBow();
		glPopMatrix();
	glPopMatrix();
}

void kittyDrawTorso(void)
{
/////////////Overalls//////////
	glBegin(GL_POLYGON);
		glColor3f(0,0,1);
		glVertex3f(0,1,0);
		glVertex3f(0.75, 1.25,0);
		glVertex3f(1,2,0);
		glVertex3f(2,2,0);
		glVertex3f(2.5,0,0);
		glVertex3f(2.75, -2, 0);
		glVertex3f(0,-2,0);
	glEnd();
	glBegin(GL_LINES);
		glColor3f(0,0,0);
		glVertex3f(0,1,0);
		glVertex3f(0.75, 1.25,0);
		glVertex3f(0.75, 1.25,0);
		glVertex3f(1,2,0);
		glVertex3f(1,2,0);
		glVertex3f(2,2,0);
		glVertex3f(2,2,0);
		glVertex3f(2.5,0,0);
		glVertex3f(2.5,0,0);
		glVertex3f(2.75, -2, 0);
		glVertex3f(2.75, -2, 0);
		glVertex3f(0,-2,0);
		glVertex3f(0,-2,0);
		glVertex3f(0,-1.5,0);
	glEnd();
/////////////Shirt/////////////
	glBegin(GL_POLYGON);
		glColor3f(1,0,0);
		glVertex3f(0,2,0);
		glVertex3f(1,2,0);
		glVertex3f(0.75, 1, 0);
		glVertex3f(0,0.5,0);
	glEnd();
	glBegin(GL_LINES);
		glColor3f(0,0,0);
		glVertex3f(0,0.5,0);
		glVertex3f(0.75, 1, 0);
		glVertex3f(0.75, 1, 0);
		glVertex3f(1,2,0);
	glEnd();
/////////////Button//////////
	glPushMatrix();
		glTranslatef(0,-1,0);
		glBegin(GL_POLYGON);
			glColor3f(1,1,0);
			glVertex3f(1.25, 0.75, 0);
			glVertex3f(1.5, 1, 0);
			glVertex3f(1.75, 1, 0);
			glVertex3f(2, 0.75, 0);
			glVertex3f(1.75, 0.5, 0);
			glVertex3f(1.5, 0.5, 0);
		glEnd();
		glBegin(GL_LINES);
			glColor3f(0,0,0);
			glVertex3f(1.25, 0.75, 0);
			glVertex3f(1.5, 1, 0);
			glVertex3f(1.5, 1, 0);
			glVertex3f(1.75, 1, 0);
			glVertex3f(1.75, 1, 0);
			glVertex3f(2, 0.75, 0);
			glVertex3f(2, 0.75, 0);
			glVertex3f(1.75, 0.5, 0);
			glVertex3f(1.75, 0.5, 0);
			glVertex3f(1.5, 0.5, 0);
			glVertex3f(1.5, 0.5, 0);
			glVertex3f(1.25, 0.75, 0);
		glEnd();
	glPopMatrix();
}

void kittyDrawBody(void)
{
	float facescale = 0.1;
	glPushMatrix();
		glScalef(facescale, facescale, facescale);
		glTranslatef(0, -2.5,0);
		kittyDrawTorso();
	glPopMatrix();
	glPushMatrix();
		glScalef(-facescale, facescale, facescale);
		glTranslatef(0, -2.5,0);
		kittyDrawTorso();
	glPopMatrix();
}

void kittyDrawFoot(void)
{
	glBegin(GL_POLYGON);
		glColor3f(1,1,1);
		glVertex3f(0,1,0);
		glVertex3f(3,1,0);
		glVertex3f(3.5, 0.75, 0);
		glVertex3f(3.75, 0.25,0);
		glVertex3f(3.75, -0.75,0);
		glVertex3f(3.5, -1, 0);
		glVertex3f(0.25, -1, 0);
		glVertex3f(0,-0.75, 0);
	glEnd();
	glBegin(GL_LINES);
		glColor3f(0,0,0);
		glVertex3f(0,1,0);
		glVertex3f(3,1,0);
		glVertex3f(3,1,0);
		glVertex3f(3.5, 0.75, 0);
		glVertex3f(3.5, 0.75, 0);
		glVertex3f(3.75, 0.25,0);
		glVertex3f(3.75, 0.25,0);
		glVertex3f(3.75, -0.75,0);
		glVertex3f(3.75, -0.75,0);
		glVertex3f(3.5, -1, 0);
		glVertex3f(3.5, -1, 0);
		glVertex3f(0.25, -1, 0);
		glVertex3f(0.25, -1, 0);
		glVertex3f(0,-0.75, 0);
		glVertex3f(0,-0.75, 0);
		glVertex3f(0,1,0);
	glEnd();
}

void kittyDrawArm(void)
{
//////////////////Sleve///////////
	glBegin(GL_POLYGON);
		glColor3f(1,0,0);
		glVertex3f(-1.5,2,0);
		glVertex3f(0,0,0);
		glVertex3f(0.5, -1, 0);
		glVertex3f(-1.5,-2,0);
	glEnd();
	glBegin(GL_LINES);
		glColor3f(0,0,0);
		glVertex3f(-1.5,2,0);
		glVertex3f(0,0,0);
		glVertex3f(0,0,0);
		glVertex3f(0.5, -1, 0);
		glVertex3f(0.5, -1, 0);
		glVertex3f(-1.5,-2,0);
		glVertex3f(-1.5,-2,0);
		glVertex3f(-1.5,2,0);
	glEnd();
///////////////Paw/////////////
	glBegin(GL_POLYGON);
		glColor3f(1,1,1);
		glVertex3f(0.5,-1,0);
		glVertex3f(1,-2,0);
		glVertex3f(1,-2.5, 0);
		glVertex3f(0.75, -3,0);
		glVertex3f(0.5,-3.25,0);
		glVertex3f(0,-3.5,0);
		glVertex3f(-0.5,-3.5, 0);
		glVertex3f(-1, -3.25, 0);
		glVertex3f(-1.25, -3, 0);
		glVertex3f(-1.5, -2.5, 0);
		glVertex3f(-1.5, -2, 0);
	glEnd();
	glBegin(GL_LINES);
		glColor3f(0,0,0);
		glVertex3f(0.5,-1,0);
		glVertex3f(1,-2,0);
		glVertex3f(1,-2,0);
		glVertex3f(1,-2.5, 0);
		glVertex3f(1,-2.5, 0);
		glVertex3f(0.75, -3,0);
		glVertex3f(0.75, -3,0);
		glVertex3f(0.5,-3.25,0);
		glVertex3f(0.5,-3.25,0);
		glVertex3f(0,-3.5,0);
		glVertex3f(0,-3.5,0);
		glVertex3f(-0.5,-3.5, 0);
		glVertex3f(-0.5,-3.5, 0);
		glVertex3f(-1, -3.25, 0);
		glVertex3f(-1, -3.25, 0);
		glVertex3f(-1.25, -3, 0);
		glVertex3f(-1.25, -3, 0);
		glVertex3f(-1.5, -2.5, 0);
		glVertex3f(-1.5, -2.5, 0);
		glVertex3f(-1.5, -2, 0);
		glVertex3f(-1.5, -2, 0);
		glVertex3f(0.5,-1,0);
	glEnd();
}

void kittyDrawRightArm(float rotation)
{
	float facescale = 0.1;
	glPushMatrix();
		glScalef(facescale, facescale, facescale);
		glTranslatef(2, -0.5,0);
		glPushMatrix();
			glRotatef(rotation,0,0,1);
			kittyDrawArm();
		glPopMatrix();
	glPopMatrix();
}

void kittyDrawLeftArm(float rotation)
{
	float facescale = 0.1;
	glPushMatrix();
		glScalef(-facescale, facescale, facescale);
		glTranslatef(2, -0.5,0);
		glPushMatrix();
			glRotatef(rotation,0,0,1);
			kittyDrawArm();
		glPopMatrix();
	glPopMatrix();
}

void kittyDrawRightFoot(float rotation)
{
	float facescale = 0.09;
	glPushMatrix();
		glScalef(facescale, facescale, facescale);
		glTranslatef(0, -5.5, 0);
		glPushMatrix();
			glRotatef(rotation, 0,0,1);
			kittyDrawFoot();
		glPopMatrix();
	glPopMatrix();
}

void kittyDrawLeftFoot(float rotation)
{
	float facescale = 0.09;
	glPushMatrix();
		glScalef(-facescale, facescale, facescale);
		glTranslatef(0, -5.5, 0);
		glPushMatrix();
			glRotatef(rotation, 0,0,1);
			kittyDrawFoot();
		glPopMatrix();
	glPopMatrix();
}

void kittyDrawShadow(void)
{
	float facescale = 0.1;
	int angle;
	float old_x = 4;
	float old_y = 0;
	float current_x;
	float current_y;
	glPushMatrix();
		glScalef(facescale, facescale, facescale);
		glTranslatef(0,-5.5,0);
		for (angle=5;angle<=360; angle+=5)
		{
			current_x = 4*cos(angle*PI/180);
			current_y = 1*sin(angle*PI/180);
			glBegin(GL_TRIANGLES);
				glColor4f(0,0,0,0.75);
				glVertex3f(0,0,0);
				glColor4f(0,0,0,0);
				glVertex3f(old_x, old_y, 0);
				glColor4f(0,0,0,0);
				glVertex3f(current_x, current_y, 0);
			glEnd();
			old_x=current_x;
			old_y=current_y;
		}
	glPopMatrix();
}