#ifndef _NATUREROOM_H
#define _NATUREROOM_H

#include <GL\glut.h>
#include <GL\glaux.h>
#include <stdio.h>
#include "genericPoly.h"
#include "math.h"

class natureroom {

public:
	natureroom();
	~natureroom();
	int DrawNatureRoom(int sector);
	int SetSector(int sector);
	int GetSector(void);
	int LoadTextures(void);
	int IncreaseRecursion(void);
	int DecreaseRecursion(void);
	int IncreaseGrass(void);
	int DecreaseGrass(void);
	AUX_RGBImageRec *LoadBMP(char *filename);
	int DoLighting(void);

private:
	int grassLayers;
	int natureSector;
	int treeDepth;
	int DrawLight(float x, float y, float z, float r, float g, float b);
	int DrawWallStrip(void);
	int DrawFloorStrip(void);
	int DrawCeilingStrip(void);
	int DrawSouthWall(void);
	int DrawWallPanel(void);
	int RecursiveTree(int depth);
	GLuint textures[4];
	float rotation, balance, length, spread, radius, tilt, degrade;

};

int natureroom::IncreaseGrass(void)
{
	if (grassLayers <20) grassLayers++;
	return 1;
}

int natureroom::DecreaseGrass(void)
{
	if (grassLayers > 3) grassLayers--;
	return 1;
}

int natureroom::IncreaseRecursion(void)
{
	if (treeDepth<10) treeDepth++;
	return 1;
}

int natureroom::DecreaseRecursion(void)
{
	if (treeDepth>1) treeDepth--;
	return 1;
}

AUX_RGBImageRec *natureroom::LoadBMP(char *filename)
{
	FILE *File = NULL;
	if (!filename) return NULL;
	File = fopen (filename, "r");
	if (File)
	{
		fclose (File);
		return auxDIBImageLoad(filename);
	}
	return NULL;
}

natureroom::natureroom()
{
	grassLayers = 10;
	natureSector = 0;
	treeDepth = 4;
	rotation = 55;
	balance = 0.05;
	length=50;
	spread = 75;
	radius = 7.5;
	tilt = 15;
	degrade = 0.85;
}

natureroom::~natureroom()
{
}

int natureroom::SetSector(int sector)
{
	natureSector = sector;
	return 1;
}

int natureroom::GetSector(void)
{
	return natureSector;
}

int natureroom::LoadTextures(void)
{
	glEnable(GL_TEXTURE_2D);
	int Status = 0;

	AUX_RGBImageRec *TextureImage[4];
	memset (TextureImage, 0, sizeof(void*)*4);

	if ((TextureImage[0] = LoadBMP("img/nature1.bmp")) &&
		(TextureImage[1] = LoadBMP("img/nature2.bmp")) &&
		(TextureImage[2] = LoadBMP("img/nature3.bmp")) &&
		(TextureImage[3] = LoadBMP("img/nature4.bmp")))
	{
		Status = 1;
		glGenTextures(4, &textures[0]);
		glBindTexture(GL_TEXTURE_2D, textures[0]);
		glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage[0]->sizeX,
			TextureImage[0]->sizeY, 0, GL_RGB,
			GL_UNSIGNED_BYTE, TextureImage[0]->data);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

		glBindTexture(GL_TEXTURE_2D, textures[1]);
		glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage[1]->sizeX,
			TextureImage[1]->sizeY, 0, GL_RGB,
			GL_UNSIGNED_BYTE, TextureImage[1]->data);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

		glBindTexture(GL_TEXTURE_2D, textures[2]);
		glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage[2]->sizeX,
			TextureImage[2]->sizeY, 0, GL_RGB,
			GL_UNSIGNED_BYTE, TextureImage[2]->data);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

		unsigned char *dataGenerated = new unsigned char[4*256*256];
		int x, index1, index2, len;
		len = 4*256*256;
		x = index1=index2 = 0;
		while (x<len)
		{
			dataGenerated[x] = TextureImage[0]->data[index1];
			index1++; x++;
			dataGenerated[x] = TextureImage[0]->data[index1];
			index1++; x++;
			dataGenerated[x] = TextureImage[0]->data[index1];
			index1++; x++;
			dataGenerated[x] = TextureImage[3]->data[index2];
			index2+=3; x++;
		}
		glBindTexture(GL_TEXTURE_2D, textures[3]);
		glTexImage2D(GL_TEXTURE_2D, 0, 4, TextureImage[3]->sizeX,
			TextureImage[3]->sizeY, 0, GL_RGBA,
			GL_UNSIGNED_BYTE, dataGenerated);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		delete [] dataGenerated;
	} else { exit(0);}

	for (int i=0;i<3;i++)
	if(TextureImage[i])
	{
		if (TextureImage[i]->data) 
		{
			free (TextureImage[i]->data);
		}
		free(TextureImage[i]);
	}

	glDisable(GL_TEXTURE_2D);
	return Status;
}

int natureroom::DrawNatureRoom(int sector)
{
	// Sector is unused at the current moment.
	// can be used later for any sort of LOD management.
	int i,k;

	DoLighting();
	
	for (i=0;i<5;i++)
	{
		glPushMatrix();
			glRotated(0,0,1,0);
			glTranslated(-150, 0, (i*60)-90);
			DrawWallPanel();
		glPopMatrix();
		glPushMatrix();
			glRotated(180,0,1,0);
			glTranslated(-150, 0, (i*60)-90);
			DrawWallPanel();
		glPopMatrix();
		glPushMatrix();
			glRotated(-90,0,1,0);
			glTranslated(-150, 0, (i*60)-90);
			DrawWallPanel();
		glPopMatrix();
	}

	for (i=0; i<15; i++)
	{
		glPushMatrix();
			glRotated(0,0,0,1);
			glTranslated(0, 0, i*(-20)+130);
			DrawWallStrip();
		glPopMatrix();
		glPushMatrix();
			glRotated(-90, 0, 1, 0);
			glTranslated(0, 0, i*(-20)+130);
			DrawWallStrip();
		glPopMatrix();
		glPushMatrix();
			glRotated(180, 0, 1, 0);
			glTranslated(0, 0, i*(-20)+130);
			DrawWallStrip();
		glPopMatrix();
		glPushMatrix();
			glRotated(0,0,0,1);
			glTranslated(0,0, i*(-20)+130);
			DrawCeilingStrip();
		glPopMatrix();
	}

	glPushMatrix();
		glRotated(180, 0,1,0);
		glTranslated(0, 0, -150);
		DrawSouthWall();
	glPopMatrix();

	//Draw Light
	DrawLight(50, 80, 50, 1,1,1);
	DrawLight(-50, 80, 50, 1,1,1);
	DrawLight(-50, 80, -50, 1,1,1);
	DrawLight(50, 80, -50, 1,1,1);

	glPushMatrix();
		glTranslated(0,-100, 0);
		RecursiveTree(0);
	glPopMatrix();

	for (i=0; i<15; i++)
	{
		glColor4f(0.5,0.5,0.5,1.0);
		glPushMatrix();
			glRotated(0,0,0,1);
			glTranslated(0,0, i*(-20)+130);
			DrawFloorStrip();
		glPopMatrix();
	}
	for (k=0; k<grassLayers; k++)
	{
		glColor4f(0.5,0.5,0.5,0.5);
//		glColor4f(1,1,1,2.0/(float)grassLayers);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		for (i=0; i<15; i++)
		{
		glPushMatrix();
			glRotated(0,0,0,1);
			glTranslated(0,(k+1)*4.0/(float)grassLayers, i*(-20)+130);
			DrawFloorStrip();
		glPopMatrix();
		}
		glDisable(GL_BLEND);
	}

	glDisable(GL_LIGHT2);
	glDisable(GL_LIGHT3);
	glDisable(GL_LIGHT4);
	glDisable(GL_LIGHT5);
	glEnable(GL_LIGHT1);
	return 1;
}

int natureroom::DrawFloorStrip(void)
{
	int i = 0;

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[3]);
	for (i=0; i<15; i++)
	{
		glPushMatrix();
//			glColor3f(0.5,0.5,0.5);
			glTranslated(i*20 - 150, 0, 0);
			glBegin(GL_QUADS);
				glNormal3f(0,1,0);
				glTexCoord2f(0,1);
				glVertex3f(0, -100, 0);
				glNormal3f(0,1,0);
				glTexCoord2f(0,0);
				glVertex3f(0, -100, 20);
				glNormal3f(0,1,0);
				glTexCoord2f(1,0);
				glVertex3f(20, -100, 20);
				glNormal3f(0,1,0);
				glTexCoord2f(1,1);
				glVertex3f(20, -100, 0);
			glEnd();
		glPopMatrix();
	}
	glDisable(GL_TEXTURE_2D);
	return 1;
}

int natureroom::DrawCeilingStrip(void)
{
	int i = 0;

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[1]);
	for (i=0; i<15; i++)
	{
		glPushMatrix();
			glColor3f(1,1,1);
			glTranslated(i*20 - 150, 0, 0);
			glBegin(GL_QUADS);
				glNormal3f(0,-1,0);
				glTexCoord2f(1,1);
				glVertex3f(20, 100, 0);
				glNormal3f(0,-1,0);
				glTexCoord2f(1,0);
				glVertex3f(20, 100, 20);
				glNormal3f(0,-1,0);
				glTexCoord2f(0,0);
				glVertex3f(0, 100, 20);
				glNormal3f(0,-1,0);
				glTexCoord2f(0,1);
				glVertex3f(0, 100, 0);
			glEnd();
		glPopMatrix();
	}
	glDisable(GL_TEXTURE_2D);
	return 1;
}

int natureroom::DrawWallStrip(void)
{
	int i=0;

	for (i=0; i<10; i++)
	{
		glPushMatrix();
		glBindTexture(GL_TEXTURE_2D, textures[1]);
		glTranslated(0, i*20 -100, 0);
		glColor3f(0.1, 0.1, 0.2);
		glBegin(GL_QUADS);
			glNormal3f(1, 0, 0);
			glTexCoord2f(0,1);
			glVertex3f(-150, 0, 0);
			glNormal3f(1, 0, 0);
			glTexCoord2f(0,0);
			glVertex3f(-150, 20, 0);
			glNormal3f(1, 0, 0);
			glTexCoord2f(1,0);
			glVertex3f(-150, 20, 20);
			glNormal3f(1, 0, 0);
			glTexCoord2f(1,1);
			glVertex3f(-150, 0, 20);
		glEnd();//GL_TRIANGLES
		glPopMatrix();
	}

	return 1;
}

int natureroom::DoLighting(void)
{
	//Lighting Setup
	GLfloat light_ambient2[] = {0.25f, 0.25f, 0.25f, 1.0f};
	GLfloat light_diffuse2[] = {0.25, 0.25, 0.25, 1.0};
	GLfloat light_position2[] = {50.0f, 80.0f, 50.0f, 1.0f};
	//Pass Lighting Info to GL Subsystem in little bits
	glLightfv(GL_LIGHT2, GL_AMBIENT, light_ambient2);
	glLightfv(GL_LIGHT2, GL_DIFFUSE, light_diffuse2);
	glLightfv(GL_LIGHT2, GL_POSITION, light_position2);
	//Make GL Subsytem "activate" our little bits.
	glDisable(GL_LIGHT1);
	glEnable(GL_LIGHT2);

	//Lighting Setup
	GLfloat light_ambient3[] = {0.25f, 0.25f, 0.25f, 1.0f};
	GLfloat light_diffuse3[] = {0.25, 0.25, 0.25, 1.0};
	GLfloat light_position3[] = {-50.0f, 80.0f, 50.0f, 1.0f};
	//Pass Lighting Info to GL Subsystem in little bits
	glLightfv(GL_LIGHT3, GL_AMBIENT, light_ambient3);
	glLightfv(GL_LIGHT3, GL_DIFFUSE, light_diffuse3);
	glLightfv(GL_LIGHT3, GL_POSITION, light_position3);
	//Make GL Subsytem "activate" our little bits.
	glEnable(GL_LIGHT3);

	//Lighting Setup
	GLfloat light_ambient4[] = {0.25f, 0.25f, 0.25f, 1.0f};
	GLfloat light_diffuse4[] = {0.25, 0.25, 0.25, 1.0};
	GLfloat light_position4[] = {-50.0f, 80.0f, -50.0f, 1.0f};
	//Pass Lighting Info to GL Subsystem in little bits
	glLightfv(GL_LIGHT4, GL_AMBIENT, light_ambient4);
	glLightfv(GL_LIGHT4, GL_DIFFUSE, light_diffuse4);
	glLightfv(GL_LIGHT4, GL_POSITION, light_position4);
	//Make GL Subsytem "activate" our little bits.
	glEnable(GL_LIGHT4);

	//Lighting Setup
	GLfloat light_ambient5[] = {0.25f, 0.25f, 0.25f, 1.0f};
	GLfloat light_diffuse5[] = {0.25, 0.25, 0.25, 1.0};
	GLfloat light_position5[] = {50.0f, 80.0f, -50.0f, 1.0f};
	//Pass Lighting Info to GL Subsystem in little bits
	glLightfv(GL_LIGHT5, GL_AMBIENT, light_ambient5);
	glLightfv(GL_LIGHT5, GL_DIFFUSE, light_diffuse5);
	glLightfv(GL_LIGHT5, GL_POSITION, light_position5);
	//Make GL Subsytem "activate" our little bits.
	glEnable(GL_LIGHT5);

	return 1;
}

int natureroom::DrawSouthWall(void)
{
	int x, y;
	//Side Walls
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[1]);
	for (x=0;x<5;x++)
	{
		for (y=0;y<10;y++)
		{
			glPushMatrix();
			glTranslated(x*20-150, y*20-100, 0);
			glBegin(GL_QUADS);
				glNormal3f(0,0,1);
				glTexCoord2f(0, 0);
				glVertex3f(0, 20, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(0, 1);
				glVertex3f(0, 0, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(1, 1);
				glVertex3f(20, 0, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(1, 0);
				glVertex3f(20, 20, 0);
			glEnd();
			glPopMatrix();
		}
	}
	for (x=0;x<5;x++)
	{
		for (y=0;y<5;y++)
		{
			glPushMatrix();
			glTranslated(x*20-50, y*20, 0);
			glBegin(GL_QUADS);
				glNormal3f(0,0,1);
				glTexCoord2f(0, 0);
				glVertex3f(0, 20, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(0, 1);
				glVertex3f(0, 0, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(1, 1);
				glVertex3f(20, 0, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(1, 0);
				glVertex3f(20, 20, 0);
			glEnd();
			glPopMatrix();
		}
	}
	for (x=0;x<5;x++)
	{
		for (y=0;y<10;y++)
		{
			glPushMatrix();
			glTranslated(x*20+50, y*20-100, 0);
			glBegin(GL_QUADS);
				glNormal3f(0,0,1);
				glTexCoord2f(0, 0);
				glVertex3f(0, 20, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(0, 1);
				glVertex3f(0, 0, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(1, 1);
				glVertex3f(20, 0, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(1, 0);
				glVertex3f(20, 20, 0);
			glEnd();
			glPopMatrix();
		}
	}
	glDisable(GL_TEXTURE_2D);
	return 1;
}

int natureroom::RecursiveTree(int depth)
{
	glColor3f(1,1,1);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[2]);
	int numSlices = 9;
	//float radius = 20;
	int x;
	float x1,z1,x2,z2;
	float i1,k1,i2,k2;
	float angle = 3.141592*2/(float)numSlices;
	for (x=0;x<numSlices;x++)
	{
		x1 = radius*cos(angle*x);
		z1 = radius*sin(angle*x);
		x2 = radius*cos(angle*(x+1));
		z2 = radius*sin(angle*(x+1));
		i1 = cos(angle*x);
		k1 = sin(angle*x);
		i2 = cos(angle*(x+1));
		k2 = sin(angle*(x+1));
		glPushMatrix();
		glBegin(GL_QUADS);
			glNormal3f(i1,0,k1);
			glTexCoord2f((x)/(float)numSlices,1);
			glVertex3f(x1,length,z1);
			glNormal3f(i2,0,k2);
			glTexCoord2f((x+1)/(float)numSlices,1);
			glVertex3f(x2,length,z2);
			glNormal3f(i2,0,k2);
			glTexCoord2f((x+1)/(float)numSlices,0);
			glVertex3f(x2,0,z2);
			glNormal3f(i1,0,k1);
			glTexCoord2f((x)/(float)numSlices,0);
			glVertex3f(x1,0,z1);
		glEnd();
		glBegin(GL_TRIANGLES);
			glNormal3f(i2,0,k2);
			glTexCoord2f((x+1)/(float)numSlices,1);
			glVertex3f(x2,length,z2);
			glNormal3f(i1,0,k1);
			glTexCoord2f((x)/(float)numSlices,1);
			glVertex3f(x1,length,z1);
			glNormal3f(0,1,0);
			glTexCoord2f(0,0);
			glVertex3f(0,length,0);
		glEnd();
		glPopMatrix();
	}
	glDisable(GL_TEXTURE_2D);

	if (depth<treeDepth)
	{
		glPushMatrix();
			glRotated(rotation, 0, 1, 0);
			glTranslated(0, length*0.9, 0);
			glPushMatrix();
				glRotated(tilt+(spread/2), 0, 0, 1);
				glScaled(degrade+balance,degrade+balance,degrade+balance);
				RecursiveTree(depth+1);
			glPopMatrix();
			glPushMatrix();
				glRotated(tilt-(spread/2), 0, 0, 1);
				glScaled(degrade-balance,degrade-balance,degrade-balance);
				RecursiveTree(depth+1);
			glPopMatrix();
		glPopMatrix();
	}

	return 1;
}

int natureroom::DrawWallPanel(void)
{
	glPushMatrix();
		glColor3f(1.0,1.0,0.9);
		glTranslated(0, -100, 0);
		glPushMatrix();
			glScaled(5, 30, 60);
			glTranslated(0.5,0.5,-0.5);
			glutSolidCube(1);
		glPopMatrix();
		glPushMatrix();
			glScaled(5, 200, 5);
			glTranslated(0.5,0.5,-0.5);
			glutSolidCube(1);
		glPopMatrix();
		glPushMatrix();
			glTranslated(0, 195, 0);
			glScaled(5, 5, 60);
			glTranslated(0.5,0.5,-0.5);
			glutSolidCube(1);
		glPopMatrix();
	glPopMatrix();

	return 1;
}

int natureroom::DrawLight(float x, float y, float z, float r, float g, float b)
{
	glDisable(GL_LIGHTING);
	glDisable(GL_CULL_FACE);
	glEnable (GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);

	float angle;
	vector axis;
	vector viewdir;
	vector newview;
	MATRIX rot;
	glGetFloatv(GL_MODELVIEW_MATRIX, rot.Data);
	viewdir.x = viewdir.y = 0;
	viewdir.z = 1;
	newview = RotateVector(rot, viewdir);
	axis = gmmCrossProduct(newview, viewdir);
	angle = gmmDotProduct(newview, viewdir);
	angle = acos(angle)*180/3.141592;

	glPushMatrix();
		glTranslatef(x,y,z);
		glRotated(angle, axis.x, axis.y, axis.z);
		glScaled(10, 10, 10);
		glPushMatrix();
			// One quadrant
			glBegin(GL_QUADS);
				glColor3f(r/2,g/2,b/2);
				glVertex3f(0,0,0);
				glColor3f(0,0,0);
				glVertex3f(0, 1, 0);
				glVertex3f(-1, 1, 0);
				glVertex3f(-1,0,0);
			glEnd();
		glPopMatrix();
		glPushMatrix();
			glRotated(90, 0, 0, 1);
			// One quadrant
			glBegin(GL_QUADS);
				glColor3f(r/2,g/2,b/2);
				glVertex3f(0,0,0);
				glColor3f(0,0,0);
				glVertex3f(0, 1, 0);
				glVertex3f(-1, 1, 0);
				glVertex3f(-1,0,0);
			glEnd();
		glPopMatrix();
		glPushMatrix();
			glRotated(180, 0, 0, 1);
			// One quadrant
			glBegin(GL_QUADS);
				glColor3f(r/2,g/2,b/2);
				glVertex3f(0,0,0);
				glColor3f(0,0,0);
				glVertex3f(0, 1, 0);
				glVertex3f(-1, 1, 0);
				glVertex3f(-1,0,0);
			glEnd();
		glPopMatrix();
		glPushMatrix();
			glRotated(270, 0, 0, 1);
			// One quadrant
			glBegin(GL_QUADS);
				glColor3f(r/2,g/2,b/2);
				glVertex3f(0,0,0);
				glColor3f(0,0,0);
				glVertex3f(0, 1, 0);
				glVertex3f(-1, 1, 0);
				glVertex3f(-1,0,0);
			glEnd();
		glPopMatrix();
	glPopMatrix();

	glDisable(GL_BLEND);
	glEnable(GL_CULL_FACE);
	glEnable(GL_LIGHTING);

	return 1;
}

#endif//_NATUREROOM_H