#ifndef _MODERNROOM_H
#define _MODERNROOM_H

#include <GL\glut.h>
#include <GL\glaux.h>
#include <stdio.h>
#include "genericPoly.h"
#include "math.h"

class modernroom {

public:
	modernroom();
	~modernroom();
	int DrawModernRoom(int sector);
	int SetSector(int sector);
	int GetSector(void);
	int LoadTextures(void);
	int IncreaseRecursion(void);
	int DecreaseRecursion(void);
	AUX_RGBImageRec *LoadBMP(char *filename);
	int DoLighting(void);

private:
	int modernSector;
	int pyramidDepth;
	vector lightPos;
	int DrawWallStrip(void);
	int DrawFloorStrip(void);
	int DrawNorthWall(void);
	int DrawColumn(void);
	int RecursivePyramid(int depth);
	int DrawLight(float x, float y, float z, float r, float g, float b);
	GLuint textures[2];

};

int modernroom::IncreaseRecursion(void)
{
	if (pyramidDepth<10) pyramidDepth++;
	return 1;
}

int modernroom::DecreaseRecursion(void)
{
	if (pyramidDepth>1) pyramidDepth--;
	return 1;
}

AUX_RGBImageRec *modernroom::LoadBMP(char *filename)
{
	FILE *File = NULL;
	if (!filename) return NULL;
	File = fopen (filename, "r");
	if (File)
	{
		fclose (File);
		return auxDIBImageLoad(filename);
	}
	return NULL;
}

modernroom::modernroom()
{
	modernSector = 0;
	pyramidDepth = 2;
}

modernroom::~modernroom()
{
}

int modernroom::SetSector(int sector)
{
	modernSector = sector;
	return 1;
}

int modernroom::GetSector(void)
{
	return modernSector;
}

int modernroom::LoadTextures(void)
{
	glEnable(GL_TEXTURE_2D);
	int Status = 0;

	AUX_RGBImageRec *TextureImage[2];
	memset (TextureImage, 0, sizeof(void*)*2);

	if ((TextureImage[0] = LoadBMP("img/modern1.bmp")) &&
		(TextureImage[1] = LoadBMP("img/modern2.bmp")))
	{
		Status = 1;
		glGenTextures(2, &textures[0]);
		glBindTexture(GL_TEXTURE_2D, textures[0]);
		glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage[0]->sizeX,
			TextureImage[0]->sizeY, 0, GL_RGB,
			GL_UNSIGNED_BYTE, TextureImage[0]->data);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

		glBindTexture(GL_TEXTURE_2D, textures[1]);
		glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage[1]->sizeX,
			TextureImage[1]->sizeY, 0, GL_RGB,
			GL_UNSIGNED_BYTE, TextureImage[1]->data);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	} else { exit(0);}

	for (int i=0;i<2;i++)
	if(TextureImage[i])
	{
		if (TextureImage[i]->data) 
		{
			free (TextureImage[i]->data);
		}
		free(TextureImage[i]);
	}

	glDisable(GL_TEXTURE_2D);
	return Status;
}

int modernroom::DrawModernRoom(int sector)
{
	// Sector is unused at the current moment.
	// can be used later for any sort of LOD management.
	int i;

	DoLighting();
	for (i=0; i<15; i++)
	{
		glPushMatrix();
			glRotated(0,0,0,1);
			glTranslated(0, 0, i*(-20)+130);
			DrawWallStrip();
		glPopMatrix();
		glPushMatrix();
			glRotated(-90, 0, 1, 0);
			glTranslated(0, 0, i*(-20)+130);
			DrawWallStrip();
		glPopMatrix();
		glPushMatrix();
			glRotated(180, 0, 1, 0);
			glTranslated(0, 0, i*(-20)+130);
			DrawWallStrip();
		glPopMatrix();
		glPushMatrix();
			glRotated(0,0,0,1);
			glTranslated(0,0, i*(-20)+130);
			DrawFloorStrip();
		glPopMatrix();
		glPushMatrix();
			glRotated(180,0,0,1);
			glTranslated(0,0, i*(-20)+130);
			DrawFloorStrip();
		glPopMatrix();
	}
	glPushMatrix();
		glTranslated(0, 0, -150);
		DrawNorthWall();
	glPopMatrix();

	glPushMatrix();
		glTranslated(75, 0, 75);
		DrawColumn();
	glPopMatrix();
	glPushMatrix();
		glTranslated(-75, 0, 75);
		DrawColumn();
	glPopMatrix();
	glPushMatrix();
		glTranslated(75, 0, -75);
		DrawColumn();
	glPopMatrix();
	glPushMatrix();
		glTranslated(-75, 0, -75);
		DrawColumn();
	glPopMatrix();

	int time_check = glutGet(GLUT_ELAPSED_TIME);
	glPushMatrix();
		glColor3f(0.8,0.8,0.8);
		glRotated(time_check/200.0, 1,0,0);
		glRotated(time_check/300.0, 0,1,0);
		glTranslated(0,-25, 0);
		glScalef(50,50,50);
		RecursivePyramid(0);
	glPopMatrix();

	for (i=0; i<5; i++)
	{
		glPushMatrix();
			glColor3f(1.0, 0.8, 0.1);
			glTranslated(0, (i*20)-50, 0);
			glRotated(90, 1,0,0);
			glutSolidTorus(5, 106.066, 18, 72);
		glPopMatrix();
	}

	DrawLight(lightPos.x, lightPos.y, lightPos.z, 1,1,1);

	glDisable(GL_LIGHT2);
	glDisable(GL_LIGHT3);
	glDisable(GL_LIGHT4);
	glDisable(GL_LIGHT5);
	glEnable(GL_LIGHT1);
	return 1;
}

int modernroom::DrawFloorStrip(void)
{
	int i = 0;

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[0]);
	for (i=0; i<15; i++)
	{
		glPushMatrix();
			glColor3f(0.8,0.8,0.8);
			glTranslated(i*20 - 150, 0, 0);
			glBegin(GL_QUADS);
				glNormal3f(0,1,0);
				glTexCoord2f(0,1);
				glVertex3f(0, -100, 0);
				glNormal3f(0,1,0);
				glTexCoord2f(0,0);
				glVertex3f(0, -100, 20);
				glNormal3f(0,1,0);
				glTexCoord2f(1,0);
				glVertex3f(20, -100, 20);
				glNormal3f(0,1,0);
				glTexCoord2f(1,1);
				glVertex3f(20, -100, 0);
			glEnd();
		glPopMatrix();
	}
	glDisable(GL_TEXTURE_2D);
	return 1;
}

int modernroom::DrawWallStrip(void)
{
	int i=0;

	for (i=0; i<10; i++)
	{
		glPushMatrix();
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, textures[1]);
		glTranslated(0, i*20 -100, 0);
		glColor3f(0.9, 0.9, 0.9);
		glBegin(GL_QUADS);
			glNormal3f(-1, 0, 0);
			glTexCoord2f(1,1);
			glVertex3f(150, 0, 20);
			glNormal3f(-1, 0, 0);
			glTexCoord2f(1,0);
			glVertex3f(150, 20, 20);
			glNormal3f(-1, 0, 0);
			glTexCoord2f(0,0);
			glVertex3f(150, 20, 0);
			glNormal3f(-1, 0, 0);
			glTexCoord2f(0,1);
			glVertex3f(150, 0, 0);
		glEnd();//GL_TRIANGLES
		glDisable(GL_TEXTURE_2D);
		glPopMatrix();
	}

	return 1;
}

int modernroom::DoLighting(void)
{
	int time_check = glutGet(GLUT_ELAPSED_TIME);
	lightPos.x = 80*sin(time_check/2000.0);
	lightPos.y = 80*sin(time_check/2100.0);
	lightPos.z = 80*sin(time_check/2200.0);
	
	//Lighting Setup
	GLfloat light_ambient2[] = {0.0f, 0.0f, 0.2f, 1.0f};
	GLfloat light_diffuse2[] = {1.0f, 1.0f, 1.0f, 1.0f};
//	GLfloat light_position2[] = {0.0f, 80.0f, 0.0f, 1.0f};
	GLfloat light_position2[] = {lightPos.x, lightPos.y,
		lightPos.z, 1.0};
	//Pass Lighting Info to GL Subsystem in little bits
	glLightfv(GL_LIGHT2, GL_AMBIENT, light_ambient2);
	glLightfv(GL_LIGHT2, GL_DIFFUSE, light_diffuse2);
	glLightfv(GL_LIGHT2, GL_POSITION, light_position2);
	//Make GL Subsytem "activate" our little bits.
	glDisable(GL_LIGHT1);
	glEnable(GL_LIGHT2);

	return 1;
}

int modernroom::DrawNorthWall(void)
{
	int x, y;
	//Side Walls
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[1]);
	for (x=0;x<5;x++)
	{
		for (y=0;y<10;y++)
		{
			glPushMatrix();
			glTranslated(x*20-150, y*20-100, 0);
			glBegin(GL_QUADS);
				glNormal3f(0,0,1);
				glTexCoord2f(0, 0);
				glVertex3f(0, 20, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(0, 1);
				glVertex3f(0, 0, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(1, 1);
				glVertex3f(20, 0, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(1, 0);
				glVertex3f(20, 20, 0);
			glEnd();
			glPopMatrix();
		}
	}
	for (x=0;x<5;x++)
	{
		for (y=0;y<5;y++)
		{
			glPushMatrix();
			glTranslated(x*20-50, y*20, 0);
			glBegin(GL_QUADS);
				glNormal3f(0,0,1);
				glTexCoord2f(0, 0);
				glVertex3f(0, 20, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(0, 1);
				glVertex3f(0, 0, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(1, 1);
				glVertex3f(20, 0, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(1, 0);
				glVertex3f(20, 20, 0);
			glEnd();
			glPopMatrix();
		}
	}
	for (x=0;x<5;x++)
	{
		for (y=0;y<10;y++)
		{
			glPushMatrix();
			glTranslated(x*20+50, y*20-100, 0);
			glBegin(GL_QUADS);
				glNormal3f(0,0,1);
				glTexCoord2f(0, 0);
				glVertex3f(0, 20, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(0, 1);
				glVertex3f(0, 0, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(1, 1);
				glVertex3f(20, 0, 0);
				glNormal3f(0,0,1);
				glTexCoord2f(1, 0);
				glVertex3f(20, 20, 0);
			glEnd();
			glPopMatrix();
		}
	}
	glDisable(GL_TEXTURE_2D);
	return 1;
}

int modernroom::DrawColumn(void)
{
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[1]);
	int numSlices = 18;
	float radius = 20;
	int x,y;
	float x1,z1,x2,z2;
	float i1,k1,i2,k2;
	float angle = 3.141592*2/(float)numSlices;
	for (x=0;x<numSlices;x++)
	{
		x1 = radius*cos(angle*x);
		z1 = radius*sin(angle*x);
		x2 = radius*cos(angle*(x+1));
		z2 = radius*sin(angle*(x+1));
		i1 = cos(angle*x);
		k1 = sin(angle*x);
		i2 = cos(angle*(x+1));
		k2 = sin(angle*(x+1));
		for (y=0;y<10;y++)
		{
			glPushMatrix();
			glTranslated(0, y*20-100, 0);
			glBegin(GL_QUADS);
				glNormal3f(i1,0,k1);
				glTexCoord2f(0,1);
				glVertex3f(x1,20,z1);
				glNormal3f(i2,0,k2);
				glTexCoord2f(1,1);
				glVertex3f(x2,20,z2);
				glNormal3f(i2,0,k2);
				glTexCoord2f(1,0);
				glVertex3f(x2,0,z2);
				glNormal3f(i1,0,k1);
				glTexCoord2f(0,0);
				glVertex3f(x1,0,z1);
			glEnd();
			glPopMatrix();
		}
	}
	glDisable(GL_TEXTURE_2D);
	return 1;
}

int modernroom::RecursivePyramid(int depth)
{
	if (depth == pyramidDepth)
	{
		glBegin(GL_TRIANGLES);
			glNormal3f(0, 0.5, -0.866);
			glVertex3f(0, 1.732, 0);
			glVertex3f(-1, 0, 1);
			glVertex3f(1, 0, 1);
		glEnd();
		glBegin(GL_TRIANGLES);
			glNormal3f(0.866, 0.5, 0);
			glVertex3f(0, 1.732, 0);
			glVertex3f(1, 0, 1);
			glVertex3f(1, 0, -1);
		glEnd();
		glBegin(GL_TRIANGLES);
			glNormal3f(0, 0.5, 0.866);
			glVertex3f(0, 1.732, 0);
			glVertex3f(1, 0, -1);
			glVertex3f(-1, 0, -1);
		glEnd();
		glBegin(GL_TRIANGLES);
			glNormal3f(-0.866, 0.5, 0);
			glVertex3f(0, 1.732, 0);
			glVertex3f(-1, 0, -1);
			glVertex3f(-1, 0, 1);
		glEnd();
		glBegin(GL_QUADS);
			glNormal3f(0, -1,0);
			glVertex3f(-1, 0, 1);
			glVertex3f(-1, 0, -1);
			glVertex3f(1, 0, -1);
			glVertex3f(1, 0, 1);
		glEnd();
	} else {
		glPushMatrix();
			glTranslated(0, 0.866, 0);
			glScalef(0.5, 0.5, 0.5);
			RecursivePyramid(depth+1);
		glPopMatrix();
		glPushMatrix();
			glTranslated(-0.5, 0, -0.5);
			glScalef(0.5, 0.5, 0.5);
			RecursivePyramid(depth+1);
		glPopMatrix();
		glPushMatrix();
			glTranslated(-0.5, 0, 0.5);
			glScalef(0.5, 0.5, 0.5);
			RecursivePyramid(depth+1);
		glPopMatrix();
		glPushMatrix();
			glTranslated(0.5, 0, -0.5);
			glScalef(0.5, 0.5, 0.5);
			RecursivePyramid(depth+1);
		glPopMatrix();
		glPushMatrix();
			glTranslated(0.5, 0, 0.5);
			glScalef(0.5, 0.5, 0.5);
			RecursivePyramid(depth+1);
		glPopMatrix();
	}

	return 1;
}

int modernroom::DrawLight(float x, float y, float z, float r, float g, float b)
{
	glDisable(GL_LIGHTING);
	glDisable(GL_CULL_FACE);
	glEnable (GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);

	float angle;
	vector axis;
	vector viewdir;
	vector newview;
	MATRIX rot;
	glGetFloatv(GL_MODELVIEW_MATRIX, rot.Data);
	viewdir.x = viewdir.y = 0;
	viewdir.z = 1;
	newview = RotateVector(rot, viewdir);
	axis = gmmCrossProduct(newview, viewdir);
	angle = gmmDotProduct(newview, viewdir);
	angle = acos(angle)*180/3.141592;

	glPushMatrix();
		glTranslatef(x,y,z);
		glRotated(angle, axis.x, axis.y, axis.z);
		glScaled(10, 10, 10);
		glPushMatrix();
			// One quadrant
			glBegin(GL_QUADS);
				glColor3f(r/2,g/2,b/2);
				glVertex3f(0,0,0);
				glColor3f(0,0,0);
				glVertex3f(0, 1, 0);
				glVertex3f(-1, 1, 0);
				glVertex3f(-1,0,0);
			glEnd();
		glPopMatrix();
		glPushMatrix();
			glRotated(90, 0, 0, 1);
			// One quadrant
			glBegin(GL_QUADS);
				glColor3f(r/2,g/2,b/2);
				glVertex3f(0,0,0);
				glColor3f(0,0,0);
				glVertex3f(0, 1, 0);
				glVertex3f(-1, 1, 0);
				glVertex3f(-1,0,0);
			glEnd();
		glPopMatrix();
		glPushMatrix();
			glRotated(180, 0, 0, 1);
			// One quadrant
			glBegin(GL_QUADS);
				glColor3f(r/2,g/2,b/2);
				glVertex3f(0,0,0);
				glColor3f(0,0,0);
				glVertex3f(0, 1, 0);
				glVertex3f(-1, 1, 0);
				glVertex3f(-1,0,0);
			glEnd();
		glPopMatrix();
		glPushMatrix();
			glRotated(270, 0, 0, 1);
			// One quadrant
			glBegin(GL_QUADS);
				glColor3f(r/2,g/2,b/2);
				glVertex3f(0,0,0);
				glColor3f(0,0,0);
				glVertex3f(0, 1, 0);
				glVertex3f(-1, 1, 0);
				glVertex3f(-1,0,0);
			glEnd();
		glPopMatrix();
	glPopMatrix();

	glDisable(GL_BLEND);
	glEnable(GL_CULL_FACE);
	glEnable(GL_LIGHTING);

	return 1;
}

#endif//_MODERNROOM_H