#ifndef _HALLWAY_H
#define _HALLWAY_H

#include <GL\glut.h>
#include <GL\glaux.h>
#include <stdio.h>
#include "genericPoly.h"
#include "math.h"

class hallway {

public:
	hallway();
	~hallway();
	int DrawHallway(int sector);
	int SetSector(int sector);
	int GetSector(void);
	int LoadTextures(void);
	AUX_RGBImageRec *LoadBMP(char *filename);
	int DoLighting(void);

private:
	int DrawLight(float x, float y, float z, float r, float g, float b);
	int hallSector;
	int DrawWallStrip(void);
	int DrawFloorStrip(void);
	GLuint textures[2];

};

AUX_RGBImageRec *hallway::LoadBMP(char *filename)
{
	FILE *File = NULL;
	if (!filename) return NULL;
	File = fopen (filename, "r");
	if (File)
	{
		fclose (File);
		return auxDIBImageLoad(filename);
	}
	return NULL;
}

hallway::hallway()
{
	hallSector = 0;
}

hallway::~hallway()
{
}

int hallway::SetSector(int sector)
{
	hallSector = sector;
	return 1;
}

int hallway::GetSector(void)
{
	return hallSector;
}

int hallway::LoadTextures(void)
{
	glEnable(GL_TEXTURE_2D);
	int Status = 0;

	AUX_RGBImageRec *TextureImage[2];
	memset (TextureImage, 0, sizeof(void*)*2);

	if ((TextureImage[0] = LoadBMP("img/hall1.bmp")) &&
		(TextureImage[1] = LoadBMP("img/hall2.bmp")))
	{
		Status = 1;
		glGenTextures(2, &textures[0]);
		glBindTexture(GL_TEXTURE_2D, textures[0]);
		glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage[0]->sizeX,
			TextureImage[0]->sizeY, 0, GL_RGB,
			GL_UNSIGNED_BYTE, TextureImage[0]->data);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

		glBindTexture(GL_TEXTURE_2D, textures[1]);
		glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage[1]->sizeX,
			TextureImage[1]->sizeY, 0, GL_RGB,
			GL_UNSIGNED_BYTE, TextureImage[1]->data);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	} else { exit(0);}

	for (int i=0;i<2;i++)
	if(TextureImage[i])
	{
		if (TextureImage[i]->data) 
		{
			free (TextureImage[i]->data);
		}
		free(TextureImage[i]);
	}

	glDisable(GL_TEXTURE_2D);
	return Status;
}

int hallway::DrawHallway(int sector)
{
	// Sector is unused at the current moment.
	// can be used later for any sort of LOD management.
	int i;

	DoLighting();
	for (i=0; i<10; i++)
	{
		glPushMatrix();
			glRotated(0,0,0,1);
			glTranslated(0, 0, i*(-20));
			DrawWallStrip();
		glPopMatrix();
		glPushMatrix();
			glRotated(90, 0, 0, 1);
			glTranslated(0, 0, i*(-20));
			DrawWallStrip();
		glPopMatrix();
		glPushMatrix();
			glRotated(180, 0, 0, 1);
			glTranslated(0, 0, i*(-20));
			DrawWallStrip();
		glPopMatrix();
		glPushMatrix();
			glRotated(0,0,0,1);
			glTranslated(0,0, i*(-20));
			DrawFloorStrip();
		glPopMatrix();
	}

	DrawLight(0,40,-100, 1,1,1);

	glDisable(GL_LIGHT2);
	glEnable(GL_LIGHT1);
	return 1;
}

int hallway::DrawFloorStrip(void)
{
	int i = 0;

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textures[1]);
	for (i=0; i<5; i++)
	{
		glPushMatrix();
			glColor3f(0.8,0.8,0.8);
			glTranslated(i*20 - 50, 0, 0);
			glBegin(GL_QUADS);
				glNormal3f(0,1,0);
				glTexCoord2f(0,1);
				glVertex3f(0, -50, -20);
				glNormal3f(0,1,0);
				glTexCoord2f(0,0);
				glVertex3f(0, -50, 0);
				glNormal3f(0,1,0);
				glTexCoord2f(1,0);
				glVertex3f(20, -50, 0);
				glNormal3f(0,1,0);
				glTexCoord2f(1,1);
				glVertex3f(20, -50, -20);
			glEnd();
		glPopMatrix();
	}
	glDisable(GL_TEXTURE_2D);
	return 1;
}

int hallway::DrawWallStrip(void)
{
	int i=0;

	for (i=0; i<5; i++)
	{
		glPushMatrix();
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, textures[0]);
		glTranslated(0, i*20 -50, 0);
		glColor3f(0.9, 0.9, 0.9);
		glBegin(GL_QUADS);
			glNormal3f(-1, 0, 0);
			glTexCoord2f(1,1);
			glVertex3f(50, 0, 0);
			glNormal3f(-1, 0, 0);
			glTexCoord2f(1,0);
			glVertex3f(50, 20, 0);
			glNormal3f(-1, 0, 0);
			glTexCoord2f(0,0);
			glVertex3f(50, 20, -20);
			glNormal3f(-1, 0, 0);
			glTexCoord2f(0,1);
			glVertex3f(50, 0, -20);
		glEnd();//GL_TRIANGLES
		glDisable(GL_TEXTURE_2D);
		glPopMatrix();
	}
	glColor3f(0.2,0.2,0.2);
	glPushMatrix();
		glScalef(1, 51, 1);
		glTranslated(50, 0, 0);
		glutSolidCube(2);
	glPopMatrix();
	glPushMatrix();
		glScalef(1, 51, 1);
		glTranslated(50, 0, -20);
		glutSolidCube(2);
	glPopMatrix();

	return 1;
}

int hallway::DoLighting(void)
{


	vector lightpos;
	lightpos.x = 0;
	lightpos.y = 40;
	lightpos.z = 50;
	MATRIX rot;

	glGetFloatv(GL_MODELVIEW_MATRIX, rot.Data);
	lightpos = RotateVector(rot, lightpos);

	//Lighting Setup
	GLfloat light_ambient2[] = {0.0f, 0.0f, 0.2f, 1.0f};
	GLfloat light_diffuse2[] = {1.0f, 1.0f, 1.0f, 1.0f};
	GLfloat light_position2[] = {0.0f, 40.0f, -100.0f, 1.0f};
	//GLfloat light_position2[] = {lightpos.x, lightpos.y, lightpos.z, 1.0};
	//Pass Lighting Info to GL Subsystem in little bits
	glLightfv(GL_LIGHT2, GL_AMBIENT, light_ambient2);
	glLightfv(GL_LIGHT2, GL_DIFFUSE, light_diffuse2);
	glLightfv(GL_LIGHT2, GL_POSITION, light_position2);
	//Make GL Subsytem "activate" our little bits.
	glDisable(GL_LIGHT1);
	glEnable(GL_LIGHT2);

	return 1;
}

int hallway::DrawLight(float x, float y, float z, float r, float g, float b)
{
	glDisable(GL_LIGHTING);
	glDisable(GL_CULL_FACE);
	glEnable (GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);

	float angle;
	vector axis;
	vector viewdir;
	vector newview;
	MATRIX rot;
	glGetFloatv(GL_MODELVIEW_MATRIX, rot.Data);
	viewdir.x = viewdir.y = 0;
	viewdir.z = 1;
	newview = RotateVector(rot, viewdir);
	axis = gmmCrossProduct(newview, viewdir);
	angle = gmmDotProduct(newview, viewdir);
	angle = acos(angle)*180/3.141592;

	glPushMatrix();
		glTranslatef(x,y,z);
		glRotated(angle, axis.x, axis.y, axis.z);
		glScaled(10, 10, 10);
		glPushMatrix();
			// One quadrant
			glBegin(GL_QUADS);
				glColor3f(r/2,g/2,b/2);
				glVertex3f(0,0,0);
				glColor3f(0,0,0);
				glVertex3f(0, 1, 0);
				glVertex3f(-1, 1, 0);
				glVertex3f(-1,0,0);
			glEnd();
		glPopMatrix();
		glPushMatrix();
			glRotated(90, 0, 0, 1);
			// One quadrant
			glBegin(GL_QUADS);
				glColor3f(r/2,g/2,b/2);
				glVertex3f(0,0,0);
				glColor3f(0,0,0);
				glVertex3f(0, 1, 0);
				glVertex3f(-1, 1, 0);
				glVertex3f(-1,0,0);
			glEnd();
		glPopMatrix();
		glPushMatrix();
			glRotated(180, 0, 0, 1);
			// One quadrant
			glBegin(GL_QUADS);
				glColor3f(r/2,g/2,b/2);
				glVertex3f(0,0,0);
				glColor3f(0,0,0);
				glVertex3f(0, 1, 0);
				glVertex3f(-1, 1, 0);
				glVertex3f(-1,0,0);
			glEnd();
		glPopMatrix();
		glPushMatrix();
			glRotated(270, 0, 0, 1);
			// One quadrant
			glBegin(GL_QUADS);
				glColor3f(r/2,g/2,b/2);
				glVertex3f(0,0,0);
				glColor3f(0,0,0);
				glVertex3f(0, 1, 0);
				glVertex3f(-1, 1, 0);
				glVertex3f(-1,0,0);
			glEnd();
		glPopMatrix();
	glPopMatrix();

	glDisable(GL_BLEND);
	glEnable(GL_CULL_FACE);
	glEnable(GL_LIGHTING);

	return 1;
}

#endif//_HALLWAY_H