// camera.cpp
// Implimentation of the camera class that manages the camera
// in the scene.

#ifndef _CAMERA_CPP
#define _CAMERA_CPP

#include <GL\glut.h>
#include <GL\gl.h>
#include <GL\glu.h>
#include "camera.h"
//#include "genericPoly.h"
#include "math.h"

myCamera::myCamera()
{
	SetPosition(0,0,0);
	SetTarget(0,0,1);
	AdjustHeadings();
}

myCamera::~myCamera()
{
}

int myCamera::SetPosition(float x, float y, float z)
{
	destPosition.x = x;
	destPosition.y = y;
	destPosition.z = z;
	AdjustHeadings();
	return 1;
}

int myCamera::SetTarget (float x, float y, float z)
{
	if ((destPosition.x == x) &&
		(destPosition.y == y) &&
		(destPosition.z == z))
		return 0;

	target.x = x;
	target.y = y;
	target.z = z;
	AdjustHeadings();
	return 1;
}

int myCamera::DoTransformations(void)
{
	//glTranslatef(-position.x, -position.y, -position.z);
	gluLookAt(position.x, position.y, position.z,
		target.x, target.y, target.z,
		0, 1, 0);
	return 1;
}

int myCamera::AdjustHeadings(void)
{
	position.x = destPosition.x;
	position.y = destPosition.y;
	position.z = destPosition.z;

	vector delta;
	float len;
	delta.x = target.x - destPosition.x;
	delta.y = target.y - destPosition.y;
	delta.z = target.z - destPosition.z;
	len = sqrt(delta.x*delta.x + delta.z*delta.z);

	heading = getAngle(delta.x, delta.z);
	pitch = getAngle(len, delta.y);

	return 1;
}

float myCamera::getAngle(float x, float y)
{
	float ang;
	if (y==0) {
		if (x>0) return 90;
		else return 270;
	} else {
		ang = abs(180.0*atan(x/y)/3.1415962);
		if (x<0) ang = 180-ang;
		if (y<0) ang = 360-ang;
		return ang;
	}
}

int myCamera::BunnyFollow(int mode, bunnyController bunny)
{
	vector newpos, newtarget;

	newpos = bunny.GetPosition();
	newtarget = bunny.GetUnitVector();

	if (0 == mode)
	{
		newtarget.x += newpos.x;
		newtarget.y += newpos.y;
		newtarget.z += newpos.z;
	}

	if (1 == mode)
	{
		newpos.x -= newtarget.x*80;
		newpos.z -= newtarget.z*80;
		newpos.y = 30;
		newtarget = bunny.GetPosition();
	}

	if (2 == mode)
	{
		newpos.x -= newtarget.x*40;
		newpos.z -= newtarget.z*40;
		newpos.y = -5;
		newtarget = bunny.GetPosition();
		newtarget.y = 30;
	}

	if (3 == mode)
	{
		newtarget = newpos;
		newtarget.y = 10;
		newpos.x = -25;
		newpos.y = 5;
		newpos.z = 25;
	}

	if (4==mode)
	{
		newtarget = newpos;
		newtarget.y = 10;
		newpos.x = 25;
		newpos.y = 150;
		newpos.z = 250;
	}

	if (5==mode)
	{
		newtarget = newpos;
		newtarget.y = 10;
		newpos.x = 55;
		newpos.y = 170;
		newpos.z = -490;
	}

	SetPosition(newpos.x, newpos.y, newpos.z);
	SetTarget(newtarget.x, newtarget.y, newtarget.z);

	return 1;
}

#endif