#ifndef _BUNNY_CONTROLLER_H
#define _BUNNY_CONTROLLER_H

#include <GL\glut.h>
#include "math.h"
#include "genericPoly.h"

class bunnyController {
public:
	bunnyController();
	~bunnyController();
	int SetVelocity(float vel);
	int Rotate(float angle);
	int SetHeading(float angle);
	int AnimateFrame(void);
	int DoTransformations(void);
	int SetPosition(float x, float y, float z);
	vector GetPosition(void);
	vector GetUnitVector(void);
	int GetSector();

private:
	vector pos;
	float heading, velocity, targetVelocity;
	int sector;
};

bunnyController::bunnyController()
{
	velocity = heading = targetVelocity = 0;
}

bunnyController::~bunnyController()
{
	// nothing to put here
}

int bunnyController::SetVelocity(float vel)
{
	targetVelocity = vel;
	return 1;
}

int bunnyController::Rotate(float angle)
{
	heading += angle;
	return 1;
}

int bunnyController::SetHeading(float angle)
{
	heading = angle;
	return 1;
}

int bunnyController::AnimateFrame(void)
{
	velocity = (velocity+targetVelocity) / 3;
	pos.x += velocity * sin(heading*3.141592/180.0);
	pos.z += velocity * cos(heading*3.141592/180.0);

	sector = -1;
	if (pos.z>-500) sector = 2;
	if (pos.z>-200) sector = 0;
	if (pos.z>0) sector = 1;

	targetVelocity /= 3;
	return 1;
}

int bunnyController::DoTransformations(void)
{
	glTranslatef(pos.x, pos.y, pos.z);
	glRotatef(heading, 0, 1, 0);
	return 1;
}

int bunnyController::SetPosition(float x, float y, float z)
{
	pos.x = x;
	pos.y = y;
	pos.z = z;

	sector = -1;
	if (z>-500) sector = 2;
	if (z>-200) sector = 0;
	if (z>0) sector = 1;

	return 1;
}

vector bunnyController::GetPosition(void)
{
	vector tempVect;
	tempVect.x = pos.x;
	tempVect.y = pos.y;
	tempVect.z = pos.z;
	return pos;
}

vector bunnyController::GetUnitVector(void)
{
	vector tempVect;
	tempVect.x = sin(heading*3.141592/180.0);
	tempVect.y = 0;
	tempVect.z = cos(heading*3.141592/180.0);
	return tempVect;
}

int bunnyController::GetSector(void)
{
	return sector;
}
#endif