// Matt Pierce
// Computer Graphics
// "bunny.h" - The file that handles the drawing of the bunny
// It loads the bunny's parts as genericModelMesh objects
// which allows a large degree of programming efficiency.
//  For example: the body, head, and snout took one week.
// Then I created and implimented the genericModelMesh objects.
// The remaining parts took one night to create.

#ifndef _BUNNY_H
#define _BUNNY_H

#include <gl/glut.h>
#include "genericPoly.h"

// Load all meshes to be used in this lab
genericModelMesh genRightArmSeg("bunnyArmSegNormals.gmm");
genericModelMesh genRightPaw("bunnyHandNormals.gmm");
genericModelMesh genHead("bunnyHeadNormals.gmm");
genericModelMesh genBody("bunnyBodyNormals.gmm");
genericModelMesh genSnout("bunnySnoutNormals.gmm");
genericModelMesh genTail("bunnyTailNormals.gmm");
genericModelMesh genEar("bunnyEarNormals.gmm");
genericModelMesh genNeck("bunnyNeckNormals.gmm");
genericModelMesh genThigh("bunnyThighNormals.gmm");
genericModelMesh genShin("bunnyShinNormals.gmm");
genericModelMesh genFoot("bunnyFootNormals.gmm");
genericModelMesh genLeftPaw("bunnyLeftHandNormals.gmm");

int bunnyCelActivated = 1;	// keep track of cel-shading
float bunnyTime;			// keep track of timer (for nicer animation)

void bunnyEnableFlat(void)
{
	genSnout.SetFlag(GENERIC_DRAW_FLAT);
	genHead.SetFlag(GENERIC_DRAW_FLAT);
	genRightPaw.SetFlag(GENERIC_DRAW_FLAT);
	genBody.SetFlag(GENERIC_DRAW_FLAT);
	genRightArmSeg.SetFlag(GENERIC_DRAW_FLAT);
	genTail.SetFlag(GENERIC_DRAW_FLAT);
	genEar.SetFlag(GENERIC_DRAW_FLAT);
	genNeck.SetFlag(GENERIC_DRAW_FLAT);
	genThigh.SetFlag(GENERIC_DRAW_FLAT);
	genShin.SetFlag(GENERIC_DRAW_FLAT);
	genFoot.SetFlag(GENERIC_DRAW_FLAT);
	genLeftPaw.SetFlag(GENERIC_DRAW_FLAT);
}

void bunnyDisableFlat(void)
{
	genSnout.UnsetFlag(GENERIC_DRAW_FLAT);
	genHead.UnsetFlag(GENERIC_DRAW_FLAT);
	genRightPaw.UnsetFlag(GENERIC_DRAW_FLAT);
	genBody.UnsetFlag(GENERIC_DRAW_FLAT);
	genRightArmSeg.UnsetFlag(GENERIC_DRAW_FLAT);
	genTail.UnsetFlag(GENERIC_DRAW_FLAT);
	genEar.UnsetFlag(GENERIC_DRAW_FLAT);
	genNeck.UnsetFlag(GENERIC_DRAW_FLAT);
	genThigh.UnsetFlag(GENERIC_DRAW_FLAT);
	genShin.UnsetFlag(GENERIC_DRAW_FLAT);
	genFoot.UnsetFlag(GENERIC_DRAW_FLAT);
	genLeftPaw.UnsetFlag(GENERIC_DRAW_FLAT);
}

// void bunnyEnableCel(void)
// turns on celshading for all bunny objects
void bunnyEnableCel(void)
{
	genSnout.SetFlag(GENERIC_CEL_SHADE);
	genHead.SetFlag(GENERIC_CEL_SHADE);
	genRightPaw.SetFlag(GENERIC_CEL_SHADE);
	genBody.SetFlag(GENERIC_CEL_SHADE);
	genRightArmSeg.SetFlag(GENERIC_CEL_SHADE);
	genTail.SetFlag(GENERIC_CEL_SHADE);
	genEar.SetFlag(GENERIC_CEL_SHADE);
	genNeck.SetFlag(GENERIC_CEL_SHADE);
	genThigh.SetFlag(GENERIC_CEL_SHADE);
	genShin.SetFlag(GENERIC_CEL_SHADE);
	genFoot.SetFlag(GENERIC_CEL_SHADE);
	genLeftPaw.SetFlag(GENERIC_CEL_SHADE);
	glDisable(GL_LIGHTING);
}

// void bunnyDisableCel(void)
// turns off celshading for all bunny objects
void bunnyDisableCel(void)
{
	genSnout.UnsetFlag(GENERIC_CEL_SHADE);
	genHead.UnsetFlag(GENERIC_CEL_SHADE);
	genRightPaw.UnsetFlag(GENERIC_CEL_SHADE);
	genBody.UnsetFlag(GENERIC_CEL_SHADE);
	genRightArmSeg.UnsetFlag(GENERIC_CEL_SHADE);
	genTail.UnsetFlag(GENERIC_CEL_SHADE);
	genEar.UnsetFlag(GENERIC_CEL_SHADE);
	genNeck.UnsetFlag(GENERIC_CEL_SHADE);
	genThigh.UnsetFlag(GENERIC_CEL_SHADE);
	genShin.UnsetFlag(GENERIC_CEL_SHADE);
	genFoot.UnsetFlag(GENERIC_CEL_SHADE);
	genLeftPaw.UnsetFlag(GENERIC_CEL_SHADE);
	glEnable(GL_LIGHTING);
}

// void bunnyToggleCel(void)
// toggles wether cel shading is on or off
void bunnyToggleCel(void)
{
	if (bunnyCelActivated == 0)
	{
		bunnyEnableCel();
		bunnyCelActivated = 1;
	}
	else 
	{
		bunnyDisableCel();
		bunnyCelActivated = 0;
	}
}

// void bunnyDraw(int Drawlines)
// draws the bunny on the screen
// Drawlines: a flag that indicates if we are currently
//	drawing the object or its outline
void bunnyDraw(int Drawlines)
{
	// A note on military right and left:
	//	military right and left are reversed, so that right
	//	is right to the observer, but left for the object.
	//	When I refer to military right, it's the object that
	//	appears on the right side of the screen, not, for example,
	//	the bunny's right hand.

	// If we aren't drawing lines, set color and get clock time
	if (Drawlines == 0) glColor3f(1.0,0.85,0.85);
	if (Drawlines == 0) bunnyTime = clock();
	
	// Because the body is the basis for positioning the model,
	// but I want to keep the feet stationary, I have to
	// find out how far the legs are extending, and move the body
	// up to compensate.
	float height = 4*sin((15.0*sin(bunnyTime/200.0))*PI/180.0)
		+ 6*sin((155 - 15.0*sin(bunnyTime/200))*PI/180.0)
		+ 4*sin((155 - 15.0*sin(bunnyTime/200))*PI/180.0);
	glPushMatrix();
	glTranslatef(0, height-6.5, 0);

	// Like Lab 1, I'm using sine waves to determine the angle
	// at which things are rotated.  This provides a nice
	// smooth oscilating motion.
	
	// Torso
	genBody.DrawModel();
	// Right Arm (military right)
	glPushMatrix();
		glTranslatef(1, 4.5, -0.5);
		glRotatef(35 + 15.0*sin(bunnyTime/200.0), 0, 0, 1);
		if (Drawlines == 0) glColor3f(1, 0.85, 0.85);
		genRightArmSeg.DrawModel();
		glPushMatrix();
			glTranslatef(0, -4, 0);
			glRotatef(125 + 15.0*sin(bunnyTime/200.0), -1, 0, 0);
			glRotatef(5, 0, -1, 0);
			if (Drawlines == 0) glColor3f(1, 0.85, 0.85);
			genRightArmSeg.DrawModel();
			glPushMatrix();
				glTranslatef(0, -4, 0);
				if (Drawlines == 0) glColor3f(1,1,1);
				genRightPaw.DrawModel();
			glPopMatrix();
		glPopMatrix();
	glPopMatrix();

	// Left Arm (military left)
	if (Drawlines == 0) glColor3f(1.0,0.85,0.85);
	glPushMatrix();
		glTranslatef(-1, 4.5, -0.5);
		glRotatef(35 - 15.0*sin(bunnyTime/200.0), 0, 0, -1);
		if (Drawlines == 0) glColor3f(1.0,0.85,0.85);
		genRightArmSeg.DrawModel();
		glPushMatrix();
			glTranslatef(0, -4, 0);
			glRotatef(125 - 15.0*sin(bunnyTime/200.0), -1, 0, 0);
			glRotatef(5, 0, 1, 0);
			if (Drawlines == 0) glColor3f(1.0,0.85,0.85);
			genRightArmSeg.DrawModel();
			glPushMatrix();
				glTranslatef(0, -4, 0);
				if (Drawlines == 0) glColor3f(1,1,1);
				genLeftPaw.DrawModel();
			glPopMatrix();
		glPopMatrix();
	glPopMatrix();


	// Head construct
	glPushMatrix();
		if (Drawlines == 0) glColor3f(1.0,0.85,0.85);
		glTranslatef(0, 5, -1);
		glRotatef(15*sin(bunnyTime/200.0), 1,0,0);
		genNeck.DrawModel();
		glPushMatrix();
			glTranslatef(0, 2, 0);
			glRotatef(15*sin(bunnyTime/200.0), 1,0,0);
			if (Drawlines == 0) glColor3f(1.0,0.85,0.85);
			genHead.DrawModel();
			//Ears
			glPushMatrix();
				glTranslatef(1, 6.5, -1.5);
				glRotatef(15, 0, 0, -1);
				glRotatef(15*sin(bunnyTime/200.0), 1,0,0);
				if (Drawlines == 0) glColor3f(1.0,0.85,0.85);
				genEar.DrawModel();
			glPopMatrix();
			glPushMatrix();
				glTranslatef(-1, 6.5, -1.5);
				glRotatef(15, 0, 0, 1);
				glRotatef(15*sin(bunnyTime/200.0), 1,0,0);
				if (Drawlines == 0) glColor3f(1.0,0.85,0.85);
				genEar.DrawModel();
			glPopMatrix();
			//Snout
			glPushMatrix();
				glTranslatef(0, 1, 2);
				if (Drawlines == 0) glColor3f(1,1,1);
				genSnout.DrawModel();
			glPopMatrix();
		glPopMatrix();
	glPopMatrix();

	// Tail
	glPushMatrix();
		glTranslatef(0, -4, -2);
		if (Drawlines == 0) glColor3f(1,1,1);
		genTail.DrawModel();
	glPopMatrix();

	// Right Leg(military right)
	glPushMatrix();
		if (Drawlines == 0) glColor3f(1, 0.85, 0.85);
		glTranslatef(2, -3, 0);
		glRotatef(15.0*sin(bunnyTime/200.0), 1, 0, 0);
		glRotatef(20, 0, 1, 0);
		genThigh.DrawModel();
		glPushMatrix();
			glTranslatef(0, -1.5, 4);
			glRotatef(155 - 15.0*sin(bunnyTime/200.0), 1, 0, 0);
			if (Drawlines == 0) glColor3f(1.0,0.85,0.85);
			genShin.DrawModel();
			glPushMatrix();
				if (Drawlines == 0) glColor3f(1,1,1);
				glTranslatef(0, 0.5, 6);
				glRotatef(155 - 15.0*sin(bunnyTime/200.0), -1, 0, 0);
				genFoot.DrawModel();
			glPopMatrix();
		glPopMatrix();
	glPopMatrix();

	// Left Leg(military left)
	glPushMatrix();
		if (Drawlines == 0) glColor3f(1, 0.85, 0.85);
		glTranslatef(-2, -3, 0);
		glRotatef(15.0*sin(bunnyTime/200.0), 1, 0, 0);
		glRotatef(20, 0, -1, 0);
		genThigh.DrawModel();
		glPushMatrix();
			glTranslatef(0, -1.5, 4);
			glRotatef(155 - 15.0*sin(bunnyTime/200.0), 1, 0, 0);
			if (Drawlines == 0) glColor3f(1.0,0.85,0.85);
			genShin.DrawModel();
			glPushMatrix();
				if (Drawlines == 0) glColor3f(1,1,1);
				glTranslatef(0, 0.5, 6);
				glRotatef(155 - 15.0*sin(bunnyTime/200.0), -1, 0, 0);
				genFoot.DrawModel();
			glPopMatrix();
		glPopMatrix();
	glPopMatrix();
	glPopMatrix();
}

#endif