// Matt Pierce
// 06 March, 2002
// "Lab4.cpp"
//
// Take the animal rendered in Lab 3, place it in an environment
// that consists of at least 3 areas.  Each area must have its own
// lighting conditions.  Also, this lab must employ the concepts of
// scene graphs, graftals, and fractals.

// Scene graphs: to follow the concepts of scene graphs, the camera
// is a class in and of itself.

// Graftals: Although graftals are usually used for plant life, I
// find that fractals are much more effective in that area.  So, to
// make sure that graftals are somewhere in this project, the
// modern room has graftal decorations on the walls.

// Fractals:  Fractals are employed in two locations: the pyramid
// in the modern room is a recursively generated structure, and the
// trees in the nature room is also a recursive structure.

#include <GL\glut.h>                // The header for GLUT
#include <math.h>                   // for sin & cos functions
#include <windows.h>
#include <time.h>
#include "genericPoly.h"
const float PI = 3.1415926;         // PI
#include "bunny.h"
#include "camera.h"
#include "bunnyController.h"
#include "hallway.h"
#include "modernroom.h"
#include "natureroom.h"

const int WINDOW_WIDE = 160;		// The initial width of the window
const int WINDOW_HIGH = 120;		// The initial height of the window
const int NUM_VIEWS = 6;

int outlineFlag = 0;
int doRotation =1;
int smoothFlag = 1;
int orthoMode = 0;
float rotationValue = 0;
int currentWidth;
int currentHeight;
myCamera camera;
bunnyController myBunny;
hallway myHallway;
modernroom myModern;
natureroom myNature;
int viewMode = 0;


void display(void)
{
//	static int time_check=glutGet(GLUT_ELAPSED_TIME);
	static int time_check = clock();
//	int time_now = glutGet(GLUT_ELAPSED_TIME);
	int time_now = clock();
	int time_elapsed;
	float rot=0;
	float framerate;
	float cameraPos;
	float cameraTar;
	glLoadIdentity();

	rot = time_now / 10.0;
	time_elapsed = time_now - time_check;

	// I base rotation off time elapsed between frames.
	// It's smooth & allows me to pause & start animation
	if (doRotation == 1)
	{
		rotationValue += time_elapsed/10.0;
	}
	
	framerate = 1000.0 / (float)time_elapsed;
	time_check = time_now;

	if (smoothFlag == 1) 
	{
		glShadeModel(GL_SMOOTH);
		bunnyDisableFlat();
	}
	else 
	{
		glShadeModel(GL_FLAT);
		bunnyEnableFlat();
	}
	
	// Allow glColor3f() statements to set object surface color
	glColorMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE);
	glEnable(GL_COLOR_MATERIAL);
	
	// Clear screen and depth buffer
	glClearColor(0.75, 0.75, 0.75, 1.0);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	// Load ID matrix, and set up our camera's view
	glLoadIdentity();
	camera.BunnyFollow(viewMode, myBunny);
	cameraPos = camera.GetPosition().z;
	cameraTar = camera.GetTarget().z;
	camera.DoTransformations();

	glEnable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);
	if (!((cameraPos > 10) && (cameraTar>cameraPos)) &&
		!((cameraPos < -210) && (cameraTar<cameraPos)))
	{
		glPushMatrix();
			glTranslated(0, 40, 0);
			myHallway.DrawHallway(0);
		glPopMatrix();
	}
	if (!((cameraPos < -10) && (cameraTar < cameraPos)))
	{
		glPushMatrix();
			glTranslated(0, 90, 150);
			myModern.DrawModernRoom(0);
		glPopMatrix();
	}
	glPushMatrix(); // Enter Bunny Drawing Area of Code
	if (myBunny.GetSector() == myHallway.GetSector()) myHallway.DoLighting();
	if (myBunny.GetSector() == myModern.GetSector()) myModern.DoLighting();
	if (myBunny.GetSector() == myNature.GetSector()) myNature.DoLighting();
	//glPolygonMode(GL_FRONT, GL_LINE);
	glColor3f(1.0, 1.0, 1.0);
/*	glRotatef(15, 1, 0,0);
	glRotatef(rotationValue/1.0, 0,1,0);*/
	myBunny.AnimateFrame();
	myBunny.DoTransformations();

	// Set up some openGL flags
	glCullFace(GL_BACK);
	glEnable(GL_LIGHTING);
	// Draw the bunny
	if (viewMode != 0) bunnyDraw(0);

	// If we are drawing outlines
	if (outlineFlag == 1)
	{
		// If we are celshading, disable momentarily
		if (bunnyCelActivated == 1) bunnyDisableCel();
		// setup GL flags for drawing the backfacing polygons as wireframes
		glDisable(GL_LIGHTING);
		glCullFace(GL_FRONT);
		glPolygonMode (GL_BACK, GL_LINE);
		glDepthFunc (GL_LEQUAL);
		glLineWidth(10);
		glColor3f(0,0,0);

		// Draw the bunny again, passing in "1" to let it know we're drawing lines
		if (viewMode != 0) bunnyDraw(1);

		// Return everything back to normal
		glPolygonMode(GL_BACK, GL_FILL);
		glCullFace(GL_BACK);
		glDepthFunc(GL_LESS);
		if (bunnyCelActivated == 1) bunnyEnableCel();
	}
	glPopMatrix();//Exit bunny drawing section
	glCullFace(GL_BACK);
	glEnable(GL_LIGHTING);
	glDepthFunc(GL_LESS);
	

	if (!((cameraPos > -190)&&(cameraTar>cameraPos)))
	{
		glPushMatrix();
			glTranslated(0, 90, -350);
			myNature.DrawNatureRoom(0);
		glPopMatrix();
	}

	// Draw to screen
	glutSwapBuffers();
	glFlush();
	// Be polite to other programs
	Sleep(5);
}

void resize(int width, int height)
{
	// Update our tracing variables
	currentWidth = width;
	currentHeight = height;

	// Calculate aspect ratio
	GLfloat aspect;
	float orthoX = 20*width/640;
	float orthoY = 20*height/640;
	if (height==0) aspect = 1.0;
	else aspect = (float)width / (float)height;
	orthoY = orthoX/aspect;
	
	// Reset our viewport

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	if (orthoMode==1)
		glOrtho(-orthoX, orthoX, -orthoY, orthoY, 1, 1000);
	else 
		gluPerspective(45.0, aspect, 1.0, 1000.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glViewport(0,0,width, height);
}

// void myGlutKeyboard(unsigned char, int, int)
// this function handles keyboard input, which right now
// just toggles some rendering states.
void myGlutKeyboard(unsigned char Key, int x, int y)
{
	switch (Key)
	{
	// User quit
	case 27:
	case 'q':
	case 'Q':
		exit(0);
		break;

	// Toggle Cel Shading
	case 'c':
	case 'C':
		bunnyToggleCel();
		break;

	// Toggle Smooth Shading
	case 's':
	case 'S':
		smoothFlag = 1-smoothFlag;
		break;
		
	// Toggle Drawing Outlines
	case 'o':
	case 'O':
		outlineFlag = 1-outlineFlag;
		break;

	// Change Projection Mode
	case 'p':
	case 'P':
		orthoMode = 1-orthoMode;
		resize(currentWidth, currentHeight);
		break;
		
	// Toggle Rotating model
	case ' ':
		doRotation = 1-doRotation;
		break;

	case 'k':
	case 'K':
		myBunny.SetVelocity(15);
		break;
	case 'j':
	case 'J':
		myBunny.Rotate(15);
		break;
	case 'l':
	case 'L':
		myBunny.Rotate(-15);
		break;
	case 'v':
	case 'V':
		viewMode = (viewMode+1)%NUM_VIEWS;
		break;
	case '+':
	case '=':
		myModern.IncreaseRecursion();
		break;
	case '-':
	case '_':
		myModern.DecreaseRecursion();
		break;
	case '1':
		myNature.DecreaseRecursion();
		break;
	case '2':
		myNature.IncreaseRecursion();
		break;
	case '3':
		myNature.DecreaseGrass();
		break;
	case '4':
		myNature.IncreaseGrass();
		break;
	}
}

void init(void)
{
	// Turn on Cel Shading by default
	bunnyEnableCel();

	// initialize camera
	camera.SetPosition(0, 100, 100);
	camera.SetTarget (0,-10,0);

	// initialize bunny controller
	myBunny.SetHeading(0);
	myBunny.SetPosition(0,0,0);

	// hint for texture engine
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);

	// initialize hallway
	myHallway.LoadTextures();
	myHallway.SetSector(0);

	// initialize Modern Room
	myModern.LoadTextures();
	myModern.SetSector(1);

	// initialize Nature Room
	myNature.LoadTextures();
	myNature.SetSector(2);

	// Set our prefered OpenGL options
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHTING);
	glEnable(GL_CULL_FACE);
	glShadeModel(GL_SMOOTH);

	// Initialize viewport
	resize(WINDOW_WIDE, WINDOW_HIGH);

	//Lighting Setup
	GLfloat light_ambient[] = {0.5f, 0.5f, 0.5f, 1.0f};
	GLfloat light_diffuse[] = {1.0f, 1.0f, 1.0f, 1.0f};
	GLfloat light_position[]= {0.0f, 0.0f, 40.1f, 1.0f};
	//Pass Lighting Info to GL Subsystem in little bits
	glLightfv(GL_LIGHT1, GL_AMBIENT, light_ambient);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, light_diffuse);
	glLightfv(GL_LIGHT1, GL_POSITION, light_position);
	//Make GL Subsytem "activate" our little bits.
	glEnable(GL_LIGHT1);


	//A third Light to make Tryon happy  :)
	GLfloat light_ambient3[] = {0.0f, 0.0f, 0.0f, 1.0f};
	GLfloat light_diffuse3[] = {0.2f, 0.0f, 0.2f, 0.1f};
	GLfloat light_position3[] = {-200.0f, 50.0f, -100.0f, 1.0f};
	//Pass Lighting Info to GL Subsystem
	glLightfv(GL_LIGHT3, GL_AMBIENT, light_ambient3);
	glLightfv(GL_LIGHT3, GL_DIFFUSE, light_diffuse3);
	glLightfv(GL_LIGHT3, GL_POSITION, light_position3);
//	glEnable(GL_LIGHT3);
}

void displayMenu(void)
{
	// These are cerr statements instead of cout because
	// Otherwise, GLUT grabs all priority and won't allow my program
	// to output these instructions to the console.
	cerr << "**************************************************\n";
	cerr << "Lab 3 - Computer Graphics\n";
	cerr << "Matt Pierce, Ramapo College of New Jersey\n";
	cerr << "Professor: Dr. Amruth Kumar\n";
	cerr << "Assignment: Create a 3D animal with OpenGL & GLUT.\n";
	cerr << "   Use heirarchal modeling for animation.\n";
	cerr << "   Impliment a minimal user interface.\n";
	cerr << "\n\n";
	cerr << "Controls:\n";
	cerr << "   Q or ESC: quit the program\n";
	cerr << "   C       : toggle cel shading (overrides shade mode)\n";
	cerr << "   S       : toggle shade mode\n";
	cerr << "   O       : toggle outlines\n";
	cerr << "   P       : toggle projection mode (ortho/perspective)\n";
	cerr << "   space   : toggle rotation\n";
	cerr << "*************************************************\n";
}

int main(int argc, char ** argv)
{
	displayMenu();			// tell the user what's going on
	glutInit(&argc, argv);	// initialize Glut
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH);
	glutInitWindowSize(WINDOW_WIDE, WINDOW_HIGH);
	glutCreateWindow("Lab 3 || Matt Pierce ");
	init();					// Call my own init function

	// Set Callback Functions
	glutKeyboardFunc(myGlutKeyboard);
	glutDisplayFunc(display);
	glutReshapeFunc(resize);
	glutIdleFunc(display);

	// Toss control over to glut
	glutMainLoop();

	// exit when done
	return 1;
}
